package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.CourseHoLessonRepository;
import com.jz.jooq.franchise.tables.pojos.CourseHoLesson;

@Lazy
@Service
public class CourseHoLessonService {

	@Autowired
	private CourseHoLessonRepository courseHoLessonRepository;

	public List<CourseHoLesson> findSimpleHoLession(String brand,
			Map<Integer, Collection<Integer>> course2LessonTimes) {
		return courseHoLessonRepository.findSimpleHoLession(brand, course2LessonTimes);
	}

	public String getLessonTitle(String brand, Integer courseId, Integer lessonTime) {
		return courseHoLessonRepository.getLessonTitle(brand, courseId, lessonTime);
	}
}
