package com.jz.jar.franchise.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.tables.pojos.CourseHo;
import com.jz.jooq.franchise.tables.pojos.CourseTomato;

public class CourseWrapper {

	private Integer courseId;
	private String courseName;
	private Integer source;
	private Integer lessonNum;
	private Integer lessonMinute;
	private Integer consumeOneLesson;
	private String courseForm;
	private String trialAge;

	private List<CourseLessonWrapper> lessons;
	private Integer onePrice;

	public static CourseWrapper ofHo(CourseHo c) {
		return new CourseWrapper().setCourseId(c.getCourseId()).setCourseName(c.getCourseName())
				.setLessonNum(c.getLessonNum()).setLessonMinute(c.getLessonMinute())
				.setConsumeOneLesson(c.getConsumeOneLesson()).setSource(1);
	}

	public static CourseWrapper ofHo(CourseTomato c) {
		return new CourseWrapper().setCourseId(c.getCourseId()).setCourseName(c.getCourseName())
				.setLessonMinute(c.getLessonMinute()).setConsumeOneLesson(c.getConsumeOneLesson())
				.setCourseForm(c.getCourseForm()).setTrialAge(c.getTrialAge());
	}

	public static CourseWrapper ofFree(int courseId, String courseName, int lessonNum) {
		return new CourseWrapper().setCourseId(courseId).setCourseName(courseName).setLessonNum(lessonNum);
	}

	public Integer getCourseId() {
		return courseId;
	}

	public CourseWrapper setCourseId(Integer courseId) {
		this.courseId = courseId;
		return this;
	}

	public String getCourseName() {
		return courseName;
	}

	public CourseWrapper setCourseName(String courseName) {
		this.courseName = courseName;
		return this;
	}

	public Integer getSource() {
		return source;
	}

	public CourseWrapper setSource(Integer source) {
		this.source = source;
		return this;
	}

	public Integer getLessonNum() {
		return lessonNum;
	}

	public CourseWrapper setLessonNum(Integer lessonNum) {
		this.lessonNum = lessonNum;
		return this;
	}

	public List<CourseLessonWrapper> getLessons() {
		return lessons;
	}

	public CourseWrapper setLessons(List<CourseLessonWrapper> lessons) {
		this.lessons = lessons;
		return this;
	}

	public CourseWrapper addLesson(CourseLessonWrapper lesson) {
		if (this.lessons == null) {
			this.lessons = Lists.newArrayList();
		}
		this.lessons.add(lesson);
		return this;
	}

	public Integer getLessonMinute() {
		return lessonMinute;
	}

	public CourseWrapper setLessonMinute(Integer lessonMinute) {
		this.lessonMinute = lessonMinute;
		return this;
	}

	public Integer getConsumeOneLesson() {
		return consumeOneLesson;
	}

	public CourseWrapper setConsumeOneLesson(Integer consumeOneLesson) {
		this.consumeOneLesson = consumeOneLesson;
		return this;
	}

	public Integer getOnePrice() {
		return onePrice;
	}

	public CourseWrapper setOnePrice(Integer onePrice) {
		this.onePrice = onePrice;
		return this;
	}

	public String getCourseForm() {
		return courseForm;
	}

	public CourseWrapper setCourseForm(String courseForm) {
		this.courseForm = courseForm;
		return this;
	}

	public String getTrialAge() {
		return trialAge;
	}

	public CourseWrapper setTrialAge(String trialAge) {
		this.trialAge = trialAge;
		return this;
	}

}
