package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class FUserRoleRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.FuserRole FUR = Tables.FUSER_ROLE;

	public List<String> getUidsByRoles(String schoolId, Collection<String> roleIds) {
		return franchiseCtx.select(FUR.FUID).from(FUR).where(FUR.SCHOOL_ID.eq(schoolId).and(FUR.FROLE_ID.in(roleIds)))
				.fetchInto(String.class);
	}

}
