package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class IpAreaBaseRepository extends FranchiseBaseRepository {
	private static final com.jz.jooq.franchise.tables.IpAreaBase IAB = Tables.IP_AREA_BASE;

	public String getProv(String halfIp, long code) {
		return franchiseCtx.select(IAB.PROV).from(IAB)
				.where(IAB.HALF_IP.eq(halfIp).and(IAB.CODE_START.le(code)).and(IAB.CODE_END.ge(code)))
				.fetchAnyInto(String.class);
	}
}
