package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanOs;

@Lazy
@Repository
public class CourseTomatoOsRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomatoPlanOs CTPO = Tables.COURSE_TOMATO_PLAN_OS;

	public List<CourseTomatoPlanOs> mutiGetAllowOs(String brandId, Collection<Integer> courseIds) {
		long current = System.currentTimeMillis();
		return franchiseCtx
				.selectFrom(CTPO)
				.where(CTPO.BRAND_ID.eq(brandId).and(CTPO.COURSE_ID.in(courseIds)).and(CTPO.START_TIME.le(current))
						.and(CTPO.END_TIME.gt(current))).and(CTPO.STATUS.eq(1)).fetchInto(CourseTomatoPlanOs.class);
	}

	public CourseTomatoPlanOs getOs(String wid) {
		return franchiseCtx.selectFrom(CTPO).where(CTPO.WID.eq(wid)).fetchAnyInto(CourseTomatoPlanOs.class);
	}

	public List<CourseTomatoPlanOs> mutiGetOsByPlanIds(Collection<String> planIds) {
		return franchiseCtx.selectFrom(CTPO).where(CTPO.PLAN_ID.in(planIds).and(CTPO.STATUS.eq(1)))
				.fetchInto(CourseTomatoPlanOs.class);
	}
}
