package com.jz.jar.franchise.service;

import java.math.BigDecimal;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.gymchina.bean.tools.PaymentHttpTool;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.jz.IdTools;
import com.jz.jar.franchise.repository.ActivityCompanyPayRepository;
import com.jz.jooq.franchise.tables.records.ActivityCompanyPayRecord;

@Lazy
@Service
public class ActivityCompnayPayService {
	private Logger logger = LoggerFactory.getLogger(ActivityCompnayPayService.class);

	@Autowired
	private ActivityCompanyPayRepository activityCompanyPayRepository;

	public boolean companyPay(String jzUrl, String paySignKey, String activityId, String openId, String type,
			double money, String otherInfo, String remark) {
		Preconditions.checkArgument(money > 0 && money <= 100, "money>0 && money<=100");
		logger.warn("activityId:" + activityId + " openId:" + openId + " type:" + type + " money:" + money);

		try {
			// 1先记录企业支付申请
			ActivityCompanyPayRecord record = new ActivityCompanyPayRecord();
			String orderId = IdTools.encode(activityId + openId);
			record.setOrderId(orderId);
			record.setActivityId(activityId);
			record.setOpenId(openId);
			record.setType(type);
			record.setMoney(new BigDecimal(money));
			record.setOtherInfo(otherInfo);
			record.setRemark(remark);
			record.setStatus(0); // 0未支付 1已完成 2已失败
			record.setCreated(System.currentTimeMillis());
			activityCompanyPayRepository.createCompanyPay(record);

			// 2向pay工程提交企业支付请求，并进行支付
			int amount = (int) Math.round(money * 100);
			Map<String, String> params = Maps.newHashMap();
			params.put("orderId", orderId);
			params.put("openId", openId);
			params.put("amount", String.valueOf(amount));
			params.put("remark", remark);
			params.put("type", "wechat_js"); // 这里一定写死是wechat_js如果需要新的商户号，再进行修改
			String sign = PaymentHttpTool.getGymchinaPayParamSign(params, paySignKey);
			params.put("sign", sign);

			String url = jzUrl + "/pay/trade/companyPay";
			String resp = ConnectPost.send(url, params, "utf8");
			logger.warn(resp);
			@SuppressWarnings("unchecked")
			Map<String, Object> map = JSON.parseObject(resp, Map.class);

			// 3企业支付结果，反写到订单表
			boolean success = MapUtils.getBooleanValue(map, "success", false);
			String paymentNo = MapUtils.getString(map, "data");
			int nextStatus = success ? 1 : 2;
			activityCompanyPayRepository.finishCompanyPay(orderId, nextStatus, paymentNo);
			return success;
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return false;
		}
	}

	public int cntByActOpenType(String activityId, String openId, String type) {
		return activityCompanyPayRepository.cntByActOpenType(activityId, openId, type);
	}

	public double getUserTotalMoney(String activityId, String openId) {
		return activityCompanyPayRepository.getUserTotalMoney(activityId, openId);
	}

	public int cntSucTotalNum(String activityId, String type) {
		return activityCompanyPayRepository.cntSucTotalNum(activityId, type);
	}
}
