/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.records.ParentInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ParentInfoRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.ParentInfo PI = Tables.PARENT_INFO;

    public void savePatentInfo(String puid, String phone, int appLogin) {
        ParentInfoRecord parent = new ParentInfoRecord();
        parent.setPuid(puid);
        parent.setPhone(phone);
        parent.setAppLogin(Integer.valueOf(appLogin));
        parent.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.franchiseCtx.insertInto((Table)PI).set((Record)parent).onDuplicateKeyIgnore().execute();
    }

    public ParentInfo getParentInfoForPhone(String phone) {
        return (ParentInfo)this.franchiseCtx.selectFrom((Table)PI).where(new Condition[]{ParentInfoRepository.PI.PHONE.eq((Object)phone)}).fetchAnyInto(ParentInfo.class);
    }

    public void updateAppLogin(String phone) {
        this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.APP_LOGIN, (Object)1).where(new Condition[]{ParentInfoRepository.PI.PHONE.eq((Object)phone).and(ParentInfoRepository.PI.APP_LOGIN.eq((Object)0))}).execute();
    }

    public void updateAddressForUid(String puid, String address) {
        this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.ADDRESS, (Object)address).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)puid)}).execute();
    }

    public ParentInfo getParentInfoForId(String uid) {
        return (ParentInfo)this.franchiseCtx.selectFrom((Table)PI).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)uid)}).fetchAnyInto(ParentInfo.class);
    }

    public int countExistUid(String ... uids) {
        return this.franchiseCtx.fetchCount((Table)PI, ParentInfoRepository.PI.PUID.in((Object[])uids));
    }

    public ParentInfo getSimpleParentInfo(String puid) {
        return (ParentInfo)this.franchiseCtx.select((SelectField)ParentInfoRepository.PI.PUID, (SelectField)ParentInfoRepository.PI.NAME, (SelectField)ParentInfoRepository.PI.AVATAR).from((TableLike)PI).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)puid)}).fetchAnyInto(ParentInfo.class);
    }

    public List<ParentInfo> getSimpleParentInfo(Collection<String> puids) {
        return this.franchiseCtx.select((SelectField)ParentInfoRepository.PI.PUID, (SelectField)ParentInfoRepository.PI.NAME, (SelectField)ParentInfoRepository.PI.AVATAR).from((TableLike)PI).where(new Condition[]{ParentInfoRepository.PI.PUID.in(puids)}).fetchInto(ParentInfo.class);
    }

    public List<ParentInfo> mutiGetParentInfo(Collection<String> puids) {
        return this.franchiseCtx.selectFrom((Table)PI).where(new Condition[]{ParentInfoRepository.PI.PUID.in(puids)}).fetchInto(ParentInfo.class);
    }

    public void updateUserInfo(String puid, String name, String avatar) {
        UpdateSetMoreStep moreStep = this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.NAME, (Object)name);
        if (StringTools.isNotEmpty((CharSequence)avatar)) {
            moreStep = moreStep.set((Field)ParentInfoRepository.PI.AVATAR, (Object)avatar);
        }
        moreStep.where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)puid)}).execute();
    }

    public void updatePhoneForWriteOff(String puid, String phone) {
        this.franchiseCtx.update((Table)PI).set((Field)ParentInfoRepository.PI.PHONE, (Object)phone).where(new Condition[]{ParentInfoRepository.PI.PUID.eq((Object)puid)}).execute();
    }
}

