package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityWechatRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityWechatUserInfo;

@Lazy
@Service
public class ActivityWechatService {

	@Autowired
	private ActivityWechatRepository activityWechatRepository;

	public String getPuidByOpenId(String openId) {
		return activityWechatRepository.getPuidByOpenId(openId);
	}

	public void recordWechatBindPuid(String openId, String puid, String activityId) {
		activityWechatRepository.recordWechatBindPuid(openId, puid, activityId);
	}

	public void insUpdateUserInfo(String openid, String nickname, String sex, String province, String city,
			String country, String headimgurl, String unionid) {
		activityWechatRepository.insUpdateUserInfo(openid, nickname, sex, province, city, country, headimgurl, unionid);
	}

	public ActivityWechatUserInfo getUserInfo(String openId) {
		return activityWechatRepository.getUserInfo(openId);
	}

	public List<ActivityWechatUserInfo> mutiGetUserInfo(Collection<String> openIds) {
		return activityWechatRepository.mutiGetUserInfo(openIds);
	}

	public Map<String, ActivityWechatUserInfo> mutiGetUserInfoMap(Collection<String> openIds) {
		return activityWechatRepository.mutiGetUserInfo(openIds).stream()
				.collect(Collectors.toMap(u -> u.getOpenid(), u -> u));
	}
}
