package com.jz.jar.franchise.service;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityRedpackRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;

@Lazy
@Service
public class ActivityRedpackService {

	private static final Logger logger = LoggerFactory.getLogger(ActivityRedpackService.class);

	@Autowired
	private ActivityRedpackRepository activityRedpackRepository;
	@Autowired
	private ActivityCompnayPayService activityCompnayPayService;

	public void recordRecom(String jzUrl, String paySignKey, String activityId, String downOpenId, String upOpenId) {
		if (upOpenId == null) {
			upOpenId = "";
		}
		if (StringUtils.equals(downOpenId, upOpenId)) {
			logger.warn("downOpenId upOpenId eq:" + downOpenId);
			upOpenId = "";
		}
		if (activityRedpackRepository.isRegDownId(activityId, downOpenId)) {
			// 只注册推荐关系一次
			return;
		}
		activityRedpackRepository.createRecom(activityId, downOpenId, upOpenId);
		activityRedpackRepository.increTotalSignNum(activityId, 1);
		if (StringUtils.isEmpty(upOpenId)) {
			// 如果上游为空，那么啥都不干
			return;
		}
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return;
		}
		String type = "down_view";
		double money = 0;
		if (setting.getViewPerNum() > 0 && setting.getViewMoney().doubleValue() > 0) {
			// 尝试给浏览红包
			int downCnts = activityRedpackRepository.cntDowns(activityId, upOpenId);
			if (downCnts <= setting.getViewPerNum() * setting.getViewMoney().doubleValue()) {
				if (downCnts % setting.getViewPerNum() == 0) { // 如果正好整除
					money = setting.getViewMoney().doubleValue();
				}
			}
		}
		activityRedpackRepository.createDetail(activityId, upOpenId, type, downOpenId,
				money > 0 ? new BigDecimal(money) : null);
		activityRedpackRepository.increRank(activityId, type, upOpenId, 1);

		if (money > 0) {
			// 自动给用户下发红包
			activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money, "",
					"参与活动获得好友浏览红包");
		}
	}

	public void recordBuy(String jzUrl, String paySignKey, String activityId, String openId, String orderNo,
			String productName) {
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return;
		}
		{
			String type = "self_buy";
			if (setting.getBuySelfMoney().doubleValue() > 0
					&& activityCompnayPayService.cntByActOpenType(activityId, openId, type) <= 0) {
				activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type, setting
						.getBuySelfMoney().doubleValue(), orderNo, "购买" + productName + "获得红包");
			}
		}
		{
			String upOpenId = activityRedpackRepository.getUpOpenId(activityId, openId);
			if (StringUtils.isNotEmpty(upOpenId)) {
				String type = "down_buy";
				double money = 0;
				if (setting.getBuyRecomMoney().doubleValue() > 0
						&& activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type) <= setting
								.getBuyMaxTime()) {
					money = setting.getBuyRecomMoney().doubleValue();
				}
				activityRedpackRepository.createDetail(activityId, upOpenId, type, openId, money > 0 ? new BigDecimal(
						money) : null);
				activityRedpackRepository.increRank(activityId, type, upOpenId, 1);

				if (money > 0) {
					// 自动给用户下发红包
					activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money, "",
							"参与活动获得好友购买红包");
				}
			}
		}
	}

	/**
	 * 这里返回填表需要自动赠送的课包
	 * */
	public String recordForm(String jzUrl, String paySignKey, String activityId, String openId) {
		ActivityTemplateRedpack setting = activityRedpackRepository.getRedpackSetting(activityId);
		if (setting == null) {
			logger.warn("setting null");
			return null;
		}
		{
			String type = "self_form";
			if (setting.getFormSelfMoney().doubleValue() > 0
					&& activityCompnayPayService.cntByActOpenType(activityId, openId, type) <= 0) {
				activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, openId, type, setting
						.getFormSelfMoney().doubleValue(), "", "参与活动获得红包");
			}
		}
		{
			String upOpenId = activityRedpackRepository.getUpOpenId(activityId, openId);
			if (StringUtils.isNotEmpty(upOpenId)) {
				String type = "down_form";
				double money = 0;
				if (setting.getFormRecomMoney().doubleValue() > 0
						&& activityCompnayPayService.cntByActOpenType(activityId, upOpenId, type) <= setting
								.getFormMaxTime()) {
					money = setting.getFormRecomMoney().doubleValue();
				}
				activityRedpackRepository.createDetail(activityId, upOpenId, type, openId, money > 0 ? new BigDecimal(
						money) : null);
				activityRedpackRepository.increRank(activityId, type, upOpenId, 1);

				if (money > 0) {
					// 自动给用户下发红包
					activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money, "",
							"参与活动获得好友报名红包");
				}
			}
		}
		return setting.getFormAutoGiftPid();
	}

	public int cntDetailPage(String activityId, String upOpenId, String type) {
		return activityRedpackRepository.cntDetailPage(activityId, upOpenId, type);
	}

	public List<ActivityRedpackDetail> getDetailPage(String activityId, String upOpenId, String type, int start,
			int size) {
		return activityRedpackRepository.getDetailPage(activityId, upOpenId, type, start, size);
	}

	public List<ActivityRedpackRank> getRank(String activityId, String type, int size) {
		return activityRedpackRepository.getRank(activityId, type, size);
	}

	public String getUpOpenId(String activityId, String downOpenId) {
		return activityRedpackRepository.getUpOpenId(activityId, downOpenId);
	}
}
