package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityWechatUserInfo;

@Lazy
@Repository
public class ActivityWechatRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityWechat WA = Tables.ACTIVITY_WECHAT;
	private static final com.jz.jooq.franchise.tables.ActivityWechatUserInfo UI = Tables.ACTIVITY_WECHAT_USER_INFO;

	public String getPuidByOpenId(String openId) {
		return franchiseCtx.select(WA.PUID).from(WA).where(WA.OPEN_ID.eq(openId)).fetchAnyInto(String.class);
	}

	public void recordWechatBindPuid(String openId, String puid, String activityId) {
		franchiseCtx.insertInto(WA, WA.OPEN_ID, WA.PUID, WA.CREATE_TIME, WA.ACTIVITY_ID)
				.values(openId, puid, System.currentTimeMillis(), activityId).onDuplicateKeyUpdate().set(WA.PUID, puid)
				.set(WA.CREATE_TIME, System.currentTimeMillis()).set(WA.ACTIVITY_ID, activityId).execute();
	}

	public void insUpdateUserInfo(String openid, String nickname, String sex, String province, String city,
			String country, String headimgurl, String unionid) {
		franchiseCtx.insertInto(UI).set(UI.OPENID, openid).set(UI.NICKNAME, nickname).set(UI.SEX, sex)
				.set(UI.PROVINCE, province).set(UI.CITY, city).set(UI.COUNTRY, country).set(UI.HEADIMGURL, headimgurl)
				.set(UI.UNIONID, unionid).set(UI.CREATED, System.currentTimeMillis()).onDuplicateKeyUpdate()
				.set(UI.NICKNAME, nickname).set(UI.SEX, sex).set(UI.PROVINCE, province).set(UI.CITY, city)
				.set(UI.COUNTRY, country).set(UI.HEADIMGURL, headimgurl).set(UI.UNIONID, unionid).execute();
	}

	public ActivityWechatUserInfo getUserInfo(String openId) {
		return franchiseCtx.selectFrom(UI).where(UI.OPENID.eq(openId)).fetchAnyInto(ActivityWechatUserInfo.class);
	}

	public List<ActivityWechatUserInfo> mutiGetUserInfo(Collection<String> openIds) {
		return franchiseCtx.selectFrom(UI).where(UI.OPENID.in(openIds)).fetchInto(ActivityWechatUserInfo.class);
	}

}
