package com.jz.jar.franchise.repository;

import java.math.BigDecimal;
import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;

@Lazy
@Repository
public class ActivityRedpackRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityTemplateRedpack TR = Tables.ACTIVITY_TEMPLATE_REDPACK;
	private static final com.jz.jooq.franchise.tables.ActivityRedpackRecom RRM = Tables.ACTIVITY_REDPACK_RECOM;
	private static final com.jz.jooq.franchise.tables.ActivityRedpackDetail RDE = Tables.ACTIVITY_REDPACK_DETAIL;
	private static final com.jz.jooq.franchise.tables.ActivityRedpackRank RRK = Tables.ACTIVITY_REDPACK_RANK;
	private static final com.jz.jooq.franchise.tables.ActivityTemplate AT = Tables.ACTIVITY_TEMPLATE;

	public ActivityTemplateRedpack getRedpackSetting(String activityId) {
		return franchiseCtx.selectFrom(TR).where(TR.ACTIVITY_ID.eq(activityId))
				.fetchAnyInto(ActivityTemplateRedpack.class);
	}

	public String getUpOpenId(String activityId, String downOpenId) {
		return franchiseCtx.select(RRM.UP_OPEN_ID).from(RRM)
				.where(RRM.ACTIVITY_ID.eq(activityId).and(RRM.DOWN_OPEN_ID.eq(downOpenId))).fetchAnyInto(String.class);
	}

	public boolean isRegDownId(String activityId, String downOpenId) {
		return franchiseCtx.fetchExists(RRM, RRM.ACTIVITY_ID.eq(activityId).and(RRM.DOWN_OPEN_ID.eq(downOpenId)));
	}

	public int cntDowns(String activityId, String upOpenId) {
		return franchiseCtx.fetchCount(RRM, RRM.ACTIVITY_ID.eq(activityId).and(RRM.UP_OPEN_ID.eq(upOpenId)));
	}

	public void createRecom(String activityId, String downOpenId, String upOpenId) {
		// 上游只绑定一次
		franchiseCtx.insertInto(RRM, RRM.ACTIVITY_ID, RRM.DOWN_OPEN_ID, RRM.UP_OPEN_ID, RRM.CREATED)
				.values(activityId, downOpenId, upOpenId, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public void createDetail(String activityId, String upOpenId, String type, String downOpenId, BigDecimal money) {
		franchiseCtx
				.insertInto(RDE, RDE.ACTIVITY_ID, RDE.UP_OPEN_ID, RDE.TYPE, RDE.DOWN_OPEN_ID, RDE.MONEY, RDE.CREATED)
				.values(activityId, upOpenId, type, downOpenId, money, System.currentTimeMillis()).execute();
	}

	public void increRank(String activityId, String type, String openId, int num) {
		franchiseCtx.insertInto(RRK, RRK.ACTIVITY_ID, RRK.TYPE, RRK.OPEN_ID, RRK.NUM)
				.values(activityId, type, openId, num).onDuplicateKeyUpdate().set(RRK.NUM, RRK.NUM.add(num)).execute();
	}

	public void increTotalSignNum(String activityId, int num) {
		franchiseCtx.update(AT).set(AT.TOTAL_SIGN_NUM, DSL.isnull(AT.TOTAL_SIGN_NUM, 0).add(num))
				.where(AT.ACTIVITY_ID.eq(activityId)).execute();
	}

	public int cntDetailPage(String activityId, String upOpenId, String type) {
		return franchiseCtx.fetchCount(RDE,
				RDE.ACTIVITY_ID.eq(activityId).and(RDE.UP_OPEN_ID.eq(upOpenId)).and(RDE.TYPE.eq(type)));
	}

	public List<ActivityRedpackDetail> getDetailPage(String activityId, String upOpenId, String type, int start,
			int size) {
		return franchiseCtx.selectFrom(RDE)
				.where(RDE.ACTIVITY_ID.eq(activityId).and(RDE.UP_OPEN_ID.eq(upOpenId)).and(RDE.TYPE.eq(type)))
				.orderBy(RDE.ID.desc()).limit(start, size).fetchInto(ActivityRedpackDetail.class);
	}

	public List<ActivityRedpackRank> getRank(String activityId, String type, int size) {
		return franchiseCtx.selectFrom(RRK).where(RRK.ACTIVITY_ID.eq(activityId).and(RRK.TYPE.eq(type)))
				.orderBy(RRK.NUM.desc()).limit(size).fetchInto(ActivityRedpackRank.class);
	}
}
