/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityCompanyPay;
import com.jz.jooq.franchise.tables.records.ActivityCompanyPayRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityCompanyPayRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.ActivityCompanyPay ACP = Tables.ACTIVITY_COMPANY_PAY;

    public void createCompanyPay(ActivityCompanyPayRecord record) {
        this.franchiseCtx.batchInsert(new TableRecord[]{record}).execute();
    }

    public ActivityCompanyPay getCompanyPayByOrderId(String orderId) {
        return (ActivityCompanyPay)this.franchiseCtx.selectFrom((Table)ACP).where(new Condition[]{ActivityCompanyPayRepository.ACP.ORDER_ID.eq((Object)orderId)}).fetchAnyInto(ActivityCompanyPay.class);
    }

    public int cntByActOpenType(String activityId, String openId, String type) {
        return this.franchiseCtx.fetchCount((Table)ACP, ActivityCompanyPayRepository.ACP.ACTIVITY_ID.eq((Object)activityId).and(ActivityCompanyPayRepository.ACP.OPEN_ID.eq((Object)openId)).and(ActivityCompanyPayRepository.ACP.TYPE.eq((Object)type)));
    }

    public void finishCompanyPay(String orderId, int status, String paymentNo) {
        this.franchiseCtx.update((Table)ACP).set((Field)ActivityCompanyPayRepository.ACP.STATUS, (Object)status).set((Field)ActivityCompanyPayRepository.ACP.PAYMENT_NO, (Object)paymentNo).where(new Condition[]{ActivityCompanyPayRepository.ACP.ORDER_ID.eq((Object)orderId)}).execute();
    }

    public List<ActivityCompanyPay> getByActOpenTypes(String activityId, String openId, Collection<String> types) {
        return this.franchiseCtx.select((SelectField)ActivityCompanyPayRepository.ACP.TYPE, (SelectField)ActivityCompanyPayRepository.ACP.MONEY, (SelectField)ActivityCompanyPayRepository.ACP.REMARK, (SelectField)ActivityCompanyPayRepository.ACP.STATUS, (SelectField)ActivityCompanyPayRepository.ACP.CREATED).from((TableLike)ACP).where(new Condition[]{ActivityCompanyPayRepository.ACP.ACTIVITY_ID.eq((Object)activityId).and(ActivityCompanyPayRepository.ACP.OPEN_ID.eq((Object)openId)).and(ActivityCompanyPayRepository.ACP.TYPE.in(types))}).fetchInto(ActivityCompanyPay.class);
    }
}

