/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.jz.jar.franchise.repository.ActivityRedpackRepository;
import com.jz.jar.franchise.service.ActivityCompnayPayService;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;
import java.math.BigDecimal;
import org.jooq.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ActivityRedpackService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRedpackService.class);
    @Autowired
    private ActivityRedpackRepository activityRedpackRepository;
    @Autowired
    private ActivityCompnayPayService activityCompnayPayService;

    public void recordRecom(String jzUrl, String paySignKey, String activityId, String downOpenId, String upOpenId) {
        int downCnts;
        if (upOpenId == null) {
            upOpenId = "";
        }
        if (StringUtils.equals((Object)downOpenId, (Object)upOpenId)) {
            logger.warn("downOpenId upOpenId eq:" + downOpenId);
            upOpenId = "";
        }
        if (this.activityRedpackRepository.isRegDownId(activityId, downOpenId)) {
            return;
        }
        this.activityRedpackRepository.createRecom(activityId, downOpenId, upOpenId);
        if (StringUtils.isEmpty((String)upOpenId)) {
            return;
        }
        ActivityTemplateRedpack setting = this.activityRedpackRepository.getRedpackSetting(activityId);
        if (setting == null) {
            logger.warn("setting null");
            return;
        }
        String type = "down_view";
        double money = 0.0;
        if (setting.getViewPerNum() > 0 && setting.getViewMoney().doubleValue() > 0.0 && (double)(downCnts = this.activityRedpackRepository.cntDowns(activityId, upOpenId)) <= (double)setting.getViewPerNum().intValue() * setting.getViewMoney().doubleValue() && downCnts % setting.getViewPerNum() == 0) {
            money = setting.getViewMoney().doubleValue();
        }
        this.activityRedpackRepository.createDetail(activityId, upOpenId, type, downOpenId, money > 0.0 ? new BigDecimal(money) : null);
        this.activityRedpackRepository.increRank(activityId, type, upOpenId, 1);
        if (money > 0.0) {
            this.activityCompnayPayService.companyPay(jzUrl, paySignKey, activityId, upOpenId, type, money, "", "\u53c2\u4e0e\u6d3b\u52a8\u83b7\u5f97\u597d\u53cb\u6d4f\u89c8\u7ea2\u5305");
        }
    }
}

