/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.ActivityRedpackRecom;
import com.jz.jooq.franchise.tables.ActivityTemplateRedpack;
import java.math.BigDecimal;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityRedpackRepository
extends FranchiseBaseRepository {
    private static final ActivityTemplateRedpack TR = Tables.ACTIVITY_TEMPLATE_REDPACK;
    private static final ActivityRedpackRecom RRM = Tables.ACTIVITY_REDPACK_RECOM;
    private static final ActivityRedpackDetail RDE = Tables.ACTIVITY_REDPACK_DETAIL;
    private static final ActivityRedpackRank RRK = Tables.ACTIVITY_REDPACK_RANK;

    public com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack getRedpackSetting(String activityId) {
        return (com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack)this.franchiseCtx.selectFrom((Table)TR).where(new Condition[]{ActivityRedpackRepository.TR.ACTIVITY_ID.eq((Object)activityId)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack.class);
    }

    public String getUpOpenId(String activityId, String downOpenId) {
        return (String)this.franchiseCtx.select((SelectField)ActivityRedpackRepository.RRM.UP_OPEN_ID).from((TableLike)RRM).where(new Condition[]{ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.DOWN_OPEN_ID.eq((Object)downOpenId))}).fetchAnyInto(String.class);
    }

    public boolean isRegDownId(String activityId, String downOpenId) {
        return this.franchiseCtx.fetchExists((Table)RRM, ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.DOWN_OPEN_ID.eq((Object)downOpenId)));
    }

    public int cntDowns(String activityId, String upOpenId) {
        return this.franchiseCtx.fetchCount((Table)RRM, ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.UP_OPEN_ID.eq((Object)upOpenId)));
    }

    public void createRecom(String activityId, String downOpenId, String upOpenId) {
        this.franchiseCtx.insertInto((Table)RRM, (Field)ActivityRedpackRepository.RRM.ACTIVITY_ID, (Field)ActivityRedpackRepository.RRM.DOWN_OPEN_ID, (Field)ActivityRedpackRepository.RRM.UP_OPEN_ID, (Field)ActivityRedpackRepository.RRM.CREATED).values((Object)activityId, (Object)downOpenId, (Object)upOpenId, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void createDetail(String activityId, String upOpenId, String type, String downOpenId, BigDecimal money) {
        this.franchiseCtx.insertInto((Table)RDE, (Field)ActivityRedpackRepository.RDE.ACTIVITY_ID, (Field)ActivityRedpackRepository.RDE.UP_OPEN_ID, (Field)ActivityRedpackRepository.RDE.TYPE, (Field)ActivityRedpackRepository.RDE.DOWN_OPEN_ID, (Field)ActivityRedpackRepository.RDE.MONEY, (Field)ActivityRedpackRepository.RDE.CREATED).values((Object)activityId, (Object)upOpenId, (Object)type, (Object)downOpenId, (Object)money, (Object)System.currentTimeMillis()).execute();
    }

    public void increRank(String activityId, String type, String openId, int num) {
        this.franchiseCtx.insertInto((Table)RRK, (Field)ActivityRedpackRepository.RRK.ACTIVITY_ID, (Field)ActivityRedpackRepository.RRK.TYPE, (Field)ActivityRedpackRepository.RRK.OPEN_ID, (Field)ActivityRedpackRepository.RRK.NUM).values((Object)activityId, (Object)type, (Object)openId, (Object)num).onDuplicateKeyUpdate().set((Field)ActivityRedpackRepository.RRK.NUM, ActivityRedpackRepository.RRK.NUM.add((Number)num)).execute();
    }
}

