package com.jz.jar.franchise.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2HoSchool;
import com.jz.jooq.franchise.tables.records.CoursePackSchoolRecord;

public class CoursePackWrapper {

	private String coursePackId;
	private String name;
	private Integer officalLesson;
	private Integer maxLeaveNum;
	private Integer days;
	private Integer enable;

	private Integer totalPrice;
	private Integer onePrice;
	// private Integer maxDiscount;

	private Integer source;

	private List<CourseWrapper> courses;

	private DiscountWrapper firstDiscount;
	private DiscountWrapper secondDiscount;
	private DiscountWrapper introDiscount;

	private Integer priority;

	public static CoursePackWrapper ofMeta(CoursePackV2 cp) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName());
	}

	public static CoursePackWrapper ofMeta(CoursePackSchool cp) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName());
	}

	public static CoursePackWrapper of(CoursePackV2 cp, CoursePackV2HoSchool price) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName())
				.setOfficalLesson(cp.getOfficalLesson()).setMaxLeaveNum(price.getMaxLeaveNum()).setDays(cp.getDays())
				.setTotalPrice(price.getTotalPrice()).setOnePrice(price.getOnePrice()).setPriority(cp.getPriority())
				.setEnable(cp.getEnable()).setSource(1);
	}

	public static CoursePackWrapper of(CoursePackSchool cp) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName())
				.setOfficalLesson(cp.getOfficalLesson()).setMaxLeaveNum(cp.getMaxLeaveNum()).setDays(cp.getDays())
				.setTotalPrice(cp.getTotalPrice()).setOnePrice(cp.getOnePrice()).setEnable(cp.getEnable()).setSource(2);
	}

	public static CoursePackWrapper ofUdCoursePack(CoursePackSchoolRecord cp) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName())
				.setOfficalLesson(cp.getOfficalLesson()).setMaxLeaveNum(cp.getMaxLeaveNum()).setDays(cp.getDays())
				.setTotalPrice(cp.getTotalPrice()).setOnePrice(cp.getOnePrice()).setEnable(cp.getEnable()).setSource(2);
	}

	public static CoursePackWrapper ofHo(CoursePackV2 cp) {
		return new CoursePackWrapper().setCoursePackId(cp.getCoursePackId()).setName(cp.getName())
				.setOfficalLesson(cp.getOfficalLesson()).setDays(cp.getDays()).setEnable(cp.getEnable())
				.setPriority(cp.getPriority()).setSource(1);
	}

	public String getCoursePackId() {
		return coursePackId;
	}

	public CoursePackWrapper setCoursePackId(String coursePackId) {
		this.coursePackId = coursePackId;
		return this;
	}

	public String getName() {
		return name;
	}

	public CoursePackWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getOfficalLesson() {
		return officalLesson;
	}

	public CoursePackWrapper setOfficalLesson(Integer officalLesson) {
		this.officalLesson = officalLesson;
		return this;
	}

	public Integer getDays() {
		return days;
	}

	public CoursePackWrapper setDays(Integer days) {
		this.days = days;
		return this;
	}

	public Integer getEnable() {
		return enable;
	}

	public CoursePackWrapper setEnable(Integer enable) {
		this.enable = enable;
		return this;
	}

	public Integer getTotalPrice() {
		return totalPrice;
	}

	public CoursePackWrapper setTotalPrice(Integer totalPrice) {
		this.totalPrice = totalPrice;
		return this;
	}

	public Integer getOnePrice() {
		return onePrice;
	}

	public CoursePackWrapper setOnePrice(Integer onePrice) {
		this.onePrice = onePrice;
		return this;
	}

	// public Integer getMaxDiscount() {
	// return maxDiscount;
	// }
	//
	// public CoursePackWrapper setMaxDiscount(Integer maxDiscount) {
	// this.maxDiscount = maxDiscount;
	// return this;
	// }

	public Integer getSource() {
		return source;
	}

	public CoursePackWrapper setSource(Integer source) {
		this.source = source;
		return this;
	}

	public List<CourseWrapper> getCourses() {
		return courses;
	}

	public CoursePackWrapper addCourse(CourseWrapper course) {
		if (this.courses == null) {
			this.courses = Lists.newArrayList();
		}
		this.courses.add(course);
		return this;
	}

	public Integer getMaxLeaveNum() {
		return maxLeaveNum;
	}

	public CoursePackWrapper setMaxLeaveNum(Integer maxLeaveNum) {
		this.maxLeaveNum = maxLeaveNum;
		return this;
	}

	public DiscountWrapper getFirstDiscount() {
		return firstDiscount;
	}

	public CoursePackWrapper setFirstDiscount(DiscountWrapper firstDiscount) {
		this.firstDiscount = firstDiscount;
		return this;
	}

	public DiscountWrapper getSecondDiscount() {
		return secondDiscount;
	}

	public CoursePackWrapper setSecondDiscount(DiscountWrapper secondDiscount) {
		this.secondDiscount = secondDiscount;
		return this;
	}

	public DiscountWrapper getIntroDiscount() {
		return introDiscount;
	}

	public CoursePackWrapper setIntroDiscount(DiscountWrapper introDiscount) {
		this.introDiscount = introDiscount;
		return this;
	}

	public Integer getPriority() {
		return priority;
	}

	public CoursePackWrapper setPriority(Integer priority) {
		this.priority = priority;
		return this;
	}

}
