/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseFreeSettingRepository;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseFreeSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Lazy
@Service
@EnableScheduling
public class CourseFreeSettingService {
    private Logger logger = LoggerFactory.getLogger(CourseFreeSettingService.class);
    @Autowired
    private CourseFreeSettingRepository courseFreeSettingRepository;
    private Map<String, Map<Integer, CourseFreeSetting>> brandMap = Maps.newHashMap();

    @PostConstruct
    public void run() throws Exception {
        this.logger.warn("CourseFreeSettingService start...");
        this.fresh();
        this.logger.warn("CourseFreeSettingService end...");
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void fresh() {
        List<CourseFreeSetting> settings = this.courseFreeSettingRepository.listFreeSetting();
        if (ArrayMapTools.isNotEmpty(settings)) {
            HashMap brandMapTemp = Maps.newHashMap();
            for (CourseFreeSetting setting : settings) {
                if (!brandMapTemp.containsKey(setting.getBrandId())) {
                    brandMapTemp.put(setting.getBrandId(), Maps.newLinkedHashMap());
                }
                ((Map)brandMapTemp.get(setting.getBrandId())).put(setting.getCourseId(), setting);
            }
            this.brandMap = brandMapTemp;
            this.logger.warn("brandMap.size:" + this.brandMap.size());
        }
    }

    public CourseWrapper getFreeCourseWrapper(String brandId, int courseId) {
        if (!this.brandMap.containsKey(brandId)) {
            return null;
        }
        Map<Integer, CourseFreeSetting> courseMap = this.brandMap.get(brandId);
        if (courseMap.containsKey(courseId)) {
            CourseFreeSetting setting = courseMap.get(courseId);
            return CourseWrapper.ofFree(setting.getCourseId(), setting.getCourseName(), setting.getLessonNum());
        }
        return null;
    }

    public List<CourseWrapper> getFreeCourses(String brandId) {
        if (!this.brandMap.containsKey(brandId)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (CourseFreeSetting setting : this.brandMap.get(brandId).values()) {
            list.add(CourseWrapper.ofFree(setting.getCourseId(), setting.getCourseName(), setting.getLessonNum()));
        }
        return list;
    }

    public CourseFreeSetting getFreeCourseForBrand(String brandId, int courseId) {
        if (!this.brandMap.containsKey(brandId) || !this.brandMap.get(brandId).containsKey(courseId)) {
            return null;
        }
        return this.brandMap.get(brandId).get(courseId);
    }
}

