/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchoolDetail;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2Detail;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2HoSchool;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CoursePackRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.CoursePackV2 CPV2 = Tables.COURSE_PACK_V2;
    private static final com.jz.jooq.franchise.tables.CoursePackV2Detail CPDV2 = Tables.COURSE_PACK_V2_DETAIL;
    private static final com.jz.jooq.franchise.tables.CoursePackV2HoSchool CPCV2 = Tables.COURSE_PACK_V2_HO_SCHOOL;
    private static final CoursePackSchool CPS = Tables.COURSE_PACK_SCHOOL;
    private static final com.jz.jooq.franchise.tables.CoursePackSchoolDetail CPSD = Tables.COURSE_PACK_SCHOOL_DETAIL;

    public List<CoursePackV2Detail> getHoDetails(String brandId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPDV2).where(new Condition[]{CoursePackRepository.CPDV2.COURSE_PACK_ID.in(coursePackIds)}).fetchInto(CoursePackV2Detail.class);
    }

    public List<Integer> getHoCourseIds(String brandId, String coursePackId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPDV2.COURSE_ID).from((TableLike)CPDV2).where(new Condition[]{CoursePackRepository.CPDV2.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPDV2.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchInto(Integer.class);
    }

    public List<CoursePackSchoolDetail> getSchoolDetail(String schoolId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPSD.COURSE_PACK_ID.in(coursePackIds))}).fetchInto(CoursePackSchoolDetail.class);
    }

    public List<Integer> getSchoolCourseIds(String schoolId, String coursePackId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPSD.COURSE_ID).from((TableLike)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPSD.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchInto(Integer.class);
    }

    public List<CoursePackV2> mutiGetEnableCoursePackHoOrder(String brandId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPV2).where(new Condition[]{CoursePackRepository.CPV2.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPV2.COURSE_PACK_ID.in(coursePackIds)).and(CoursePackRepository.CPV2.ENABLE.eq((Object)1))}).orderBy(CoursePackRepository.CPV2.CREATE_TIME.asc()).fetchInto(CoursePackV2.class);
    }

    public List<CoursePackV2> mutiGetCoursePackHo(String brandId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPV2).where(new Condition[]{CoursePackRepository.CPV2.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPV2.COURSE_PACK_ID.in(coursePackIds))}).fetchInto(CoursePackV2.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchool> mutiGetPackSchool(String schoolId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPS.COURSE_PACK_ID.in(coursePackIds))}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchool> mutiGetPackSchool(Collection<String> schoolIds, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.in(schoolIds).and(CoursePackRepository.CPS.COURSE_PACK_ID.in(coursePackIds))}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public CoursePackV2 getCoursePackHo(String brandId, String coursePackId) {
        return (CoursePackV2)this.franchiseCtx.selectFrom((Table)CPV2).where(new Condition[]{CoursePackRepository.CPV2.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPV2.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchAnyInto(CoursePackV2.class);
    }

    public CoursePackV2HoSchool getCoursePackCity(String schoolId, String coursePackId) {
        return (CoursePackV2HoSchool)this.franchiseCtx.selectFrom((Table)CPCV2).where(new Condition[]{CoursePackRepository.CPCV2.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPCV2.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchAnyInto(CoursePackV2HoSchool.class);
    }

    public com.jz.jooq.franchise.tables.pojos.CoursePackSchool getCoursePackSchool(String schoolId, String coursePackId) {
        return (com.jz.jooq.franchise.tables.pojos.CoursePackSchool)this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPS.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public List<String> getHoPackIdsByCourseId(String brandId, int courseId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPDV2.COURSE_PACK_ID).from((TableLike)CPDV2).where(new Condition[]{CoursePackRepository.CPDV2.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPDV2.COURSE_ID.eq((Object)courseId))}).fetchInto(String.class);
    }

    public List<String> getSchoolPackIdsByCourseId(String schoolId, int courseId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPSD.COURSE_PACK_ID).from((TableLike)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPSD.COURSE_ID.eq((Object)courseId))}).fetchInto(String.class);
    }
}

