package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class ManageSettingRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ManageSetting MS = Tables.MANAGE_SETTING;

	public List<String> filterOnlineFreeStudySchools(Collection<String> schoolIds) {
		return franchiseCtx.select(MS.SCHOOL_ID).from(MS)
				.where(MS.SCHOOL_ID.in(schoolIds).and(MS.ONLINE_STUDY_TYPE.eq(2))).fetchInto(String.class);
	}

}
