/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseTomatoPlanRepository;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlan;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoSchoolPlan;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CourseTomatoService {
    @Autowired
    private CourseTomatoPlanRepository courseTomatoPlanRepository;

    public Map<String, String> mutiCalSchoolSimplePlans(String brandId, List<Lesson> lessons) {
        if (ArrayMapTools.isEmpty(lessons)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        HashMap startTime2MondayMap = Maps.newHashMap();
        HashMap courseId2MondaysMap = Maps.newHashMap();
        ArrayList schoolIdCourseIdMondayList = Lists.newArrayList();
        HashSet auditionIds = Sets.newHashSet();
        HashSet schoolIds = Sets.newHashSet();
        for (Lesson l : lessons) {
            int courseId = l.getCourseId();
            if (courseId < 0) {
                auditionIds.add(l.getContent());
                schoolIds.add(l.getSchoolId());
                continue;
            }
            long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
            String monday = df.format(this.getMondayOfThisWeek(startTime));
            if (courseId2MondaysMap.containsKey(courseId)) {
                ((Set)courseId2MondaysMap.get(courseId)).add(monday);
            } else {
                courseId2MondaysMap.put(courseId, Sets.newHashSet((Object[])new String[]{monday}));
            }
            startTime2MondayMap.put(startTime, monday);
            schoolIdCourseIdMondayList.add(Triple.of((Object)l.getSchoolId(), (Object)l.getCourseId(), (Object)monday));
        }
        HashMap courseIdMonday2NameMap = null;
        HashMap schoolCourseIdMonday2NameMap = null;
        if (ArrayMapTools.isNotEmpty((Collection)schoolIdCourseIdMondayList)) {
            courseIdMonday2NameMap = Maps.newHashMap();
            List<CourseTomatoPlan> hoPlans = this.courseTomatoPlanRepository.getSimplePlansByCourseId2MondayMap(brandId, courseId2MondaysMap);
            for (CourseTomatoPlan p : hoPlans) {
                String key = p.getCourseId() + "$" + p.getMonday();
                courseIdMonday2NameMap.put(key, p.getName());
            }
            schoolCourseIdMonday2NameMap = Maps.newHashMap();
            List<CourseTomatoSchoolPlan> schoolPlans = this.courseTomatoPlanRepository.getSimplePlansByTriple(schoolIdCourseIdMondayList);
            if (ArrayMapTools.isNotEmpty(schoolPlans)) {
                List<String> planIds = schoolPlans.stream().map(c -> c.getPlanId()).collect(Collectors.toList());
                Map<String, String> schoolPlanMap = this.courseTomatoPlanRepository.mutiGetPlanMap(brandId, planIds);
                for (CourseTomatoSchoolPlan sp : schoolPlans) {
                    if (!schoolPlanMap.containsKey(sp.getPlanId())) continue;
                    String key = sp.getSchoolId() + "$" + sp.getCourseId() + "$" + sp.getMonday();
                    schoolCourseIdMonday2NameMap.put(key, schoolPlanMap.get(sp.getPlanId()));
                }
            }
        }
        Map<String, String> auditionMap = null;
        if (ArrayMapTools.isNotEmpty((Collection)auditionIds)) {
            auditionMap = this.courseTomatoPlanRepository.mutiGetAuditionMap(brandId, schoolIds, auditionIds);
        }
        HashMap rsMap = Maps.newHashMap();
        for (Lesson l : lessons) {
            int courseId = l.getCourseId();
            if (courseId < 0) {
                if (!auditionMap.containsKey(l.getContent())) continue;
                rsMap.put(l.getLessonId(), auditionMap.get(l.getContent()));
                continue;
            }
            if (schoolCourseIdMonday2NameMap == null || schoolCourseIdMonday2NameMap == null) continue;
            long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
            String monday = (String)startTime2MondayMap.get(startTime);
            String schoolKey = l.getSchoolId() + "$" + l.getCourseId() + "$" + monday;
            String hoKey = l.getCourseId() + "$" + monday;
            if (schoolCourseIdMonday2NameMap.containsKey(schoolKey)) {
                rsMap.put(l.getLessonId(), schoolCourseIdMonday2NameMap.get(schoolKey));
                continue;
            }
            if (!courseIdMonday2NameMap.containsKey(hoKey)) continue;
            rsMap.put(l.getLessonId(), courseIdMonday2NameMap.get(hoKey));
        }
        return rsMap;
    }

    public String calSchoolSimplePlan(String brandId, Lesson l) {
        if (l == null) {
            return null;
        }
        String schoolId = l.getSchoolId();
        int courseId = l.getCourseId();
        if (courseId < 0) {
            String auditionId = l.getContent();
            return this.courseTomatoPlanRepository.getAuditionName(brandId, schoolId, auditionId);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
        String monday = df.format(this.getMondayOfThisWeek(startTime));
        CourseTomatoSchoolPlan schoolPlan = this.courseTomatoPlanRepository.getSchoolPlan(schoolId, courseId, monday);
        if (schoolPlan != null) {
            return this.courseTomatoPlanRepository.getPlanName(brandId, schoolPlan.getPlanId());
        }
        return this.courseTomatoPlanRepository.getHoPlanName(brandId, courseId, monday);
    }

    private Date getMondayOfThisWeek(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        if (c.get(7) == 1) {
            c.add(5, -1);
        }
        c.set(7, 2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Map<Integer, String> getCourseTomatoNameForIds(String brandId, Collection<Integer> courseIds) {
        return this.courseTomatoPlanRepository.getCourseTomatoNameForIds(brandId, courseIds);
    }

    public String getCourseTomatoNameForId(String brandId, Integer courseId) {
        return this.courseTomatoPlanRepository.getCourseTomatoNameForId(brandId, courseId);
    }

    public Map<String, String> mutiGetPlanMap(String brandId, List<String> planIds) {
        return this.courseTomatoPlanRepository.mutiGetPlanMap(brandId, planIds);
    }
}

