package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ManageSetting;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class FranchiseManageRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ManageSetting MS = Tables.MANAGE_SETTING;

	public ManageSetting getManageSetting(String schoolId) {
		return franchiseCtx.selectFrom(MS).where(MS.SCHOOL_ID.eq(schoolId)).fetchAnyInto(ManageSetting.class);
	}

}
