/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.HuserRole;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class HUserRoleRepository
extends FranchiseBaseRepository {
    private static final HuserRole H = Tables.HUSER_ROLE;

    public boolean isSuperAdmin(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.eq((Object)"super_admin")));
    }

    public List<String> getSuperAdmins() {
        return this.franchiseCtx.select((SelectField)HUserRoleRepository.H.HUID).from((TableLike)H).where(new Condition[]{HUserRoleRepository.H.HROLE_ID.eq((Object)"super_admin")}).fetchInto(String.class);
    }

    public List<String> getHrs() {
        return this.franchiseCtx.select((SelectField)HUserRoleRepository.H.HUID).from((TableLike)H).where(new Condition[]{HUserRoleRepository.H.HROLE_ID.in((Object[])new String[]{"hr", "hr_master"})}).fetchInto(String.class);
    }

    public void deleteHrs(String uid) {
        this.franchiseCtx.deleteFrom((Table)H).where(new Condition[]{HUserRoleRepository.H.HUID.eq((Object)uid)}).execute();
    }

    public boolean isIntegrated(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.in((Object[])new String[]{"integrated_manager", "integrated_master"})));
    }

    public boolean isOaContract(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.in((Object[])new String[]{"oa_contract", "super_admin"})));
    }

    public boolean isHrMaster(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.in((Object[])new String[]{"hr_master", "super_admin", "ceo"})));
    }

    public boolean isFinMaster(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.eq((Object)"fin_master")));
    }

    public boolean isGroupAssetKeeper(String uid) {
        return this.franchiseCtx.fetchExists((Table)H, HUserRoleRepository.H.HUID.eq((Object)uid).and(HUserRoleRepository.H.HROLE_ID.eq((Object)"group_asset_keeper")));
    }
}

