package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentSchoolContractRepository;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolExtra;

@Lazy
@Service
public class StudentSchoolContractService {

	@Autowired
	private StudentSchoolContractRepository studentSchoolContractRepository;

	public Pair<Integer, Integer> getLessionCount(String suid) {
		return studentSchoolContractRepository.getLessionCount(suid);
	}

	public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids) {
		return studentSchoolContractRepository.getLessionCount(suids);
	}

	/** 获取当前合同已经请假的天数 */
	public List<StudentSchoolContract> getSimpleStudentSchoolContracts(String suid,
			Map<String, Collection<String>> school2ContractId) {
		return studentSchoolContractRepository.getSimpleStudentSchoolContracts(suid, school2ContractId);
	}

	public StudentSchoolContract getStudentSchoolContract(String suid, String school, String contractId) {
		return studentSchoolContractRepository.getStudentSchoolContract(suid, school, contractId);
	}

	public void addLeaveNum(String suid, String school, String contractId, int addCnt) {
		studentSchoolContractRepository.addLeaveNum(suid, school, contractId, addCnt);
	}
	
	public List<String> getIsContinueContract(List<String> contractIds) {
		return studentSchoolContractRepository.getIsContinueContract(contractIds);
	}
	
	public boolean dealRollbackOfficalLesson(String suid, String schoolId, String contractId, int rollbackNum) {
		return studentSchoolContractRepository.dealRollbackOfficalLesson(suid, schoolId, contractId, rollbackNum);
	}

	public boolean dealRollbackExtraLesson(String suid, String schoolId, int extraId, int rollbackNum) {
		return studentSchoolContractRepository.dealRollbackExtraLesson(suid, schoolId, extraId, rollbackNum);
	}
	
	/** 获取学员的课时数 */
	public Map<String, List<StudentSchoolContract>> getStudentLessonCount(Collection<String> suids) {
		return studentSchoolContractRepository.getStudentLessonCount(suids);
	}
	
	/** 获取学员的赠课时数 */
	public Map<String, List<StudentSchoolExtra>> getStudentExtraLessonCount(Map<String, List<String>> suid2SchoolIds) {
		return studentSchoolContractRepository.getStudentExtraLessonCount(suid2SchoolIds);
	}
}
