package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.records.StudentInfoRecord;

/**
 * @Title StudentInfoRepository
 * @Package com.jz.jar.franchise.repository
 * @author tangjunfeng
 * @date 2018年8月3日 下午3:17:40
 * @version V1.0
 */
@Lazy
@Repository
public class StudentInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentInfo SI = Tables.STUDENT_INFO;

	public String getStudentBirthday(String suid) {
		return franchiseCtx.select(SI.BIRTHDAY).from(SI).where(SI.SUID.eq(suid)).fetchAnyInto(String.class);
	}

	public void refreshStudent(String puid, String suid, String cnName, String enName, String sex, String birthday,
			String avatar, String pinyin, String pinyingSimple) {
		StudentInfoRecord student = new StudentInfoRecord();
		student.setSuid(suid);
		student.setPuid(puid);
		student.setName(cnName);
		student.setNamePy(pinyin);
		student.setNamePySimple(pinyingSimple);
		student.setSex(sex);
		student.setBirthday(birthday);
		student.setEngName(enName);
		student.setAvatar(avatar);
		student.setCreated(System.currentTimeMillis());
		franchiseCtx.insertInto(SI).set(student).onDuplicateKeyUpdate().set(SI.NAME, cnName).set(SI.SEX, sex)
				.set(SI.BIRTHDAY, birthday).set(SI.ENG_NAME, enName).set(SI.AVATAR, avatar).execute();
	}

	public List<StudentInfo> getStudents(String puid) {
		return franchiseCtx.selectFrom(SI).where(SI.PUID.eq(puid)).fetchInto(StudentInfo.class);
	}

	public StudentInfo getStudent(String suid) {
		return franchiseCtx.selectFrom(SI).where(SI.SUID.eq(suid)).fetchAnyInto(StudentInfo.class);
	}

	public StudentInfo getSimpleStudentInfo(String suid) {
		return franchiseCtx.select(SI.PUID, SI.SUID, SI.NAME, SI.BIRTHDAY, SI.AVATAR).from(SI).where(SI.SUID.eq(suid))
				.fetchAnyInto(StudentInfo.class);
	}

	public List<StudentInfo> getSimpleStudentInfo(Collection<String> puids) {
		return franchiseCtx.select(SI.PUID, SI.SUID, SI.NAME, SI.BIRTHDAY, SI.AVATAR).from(SI).where(SI.PUID.in(puids))
				.orderBy(SI.BIRTHDAY.asc()).fetchInto(StudentInfo.class);
	}

	public List<StudentInfo> getSimpleStudentInfoForSuid(Collection<String> suids) {
		return franchiseCtx.select(SI.SUID, SI.NAME, SI.BIRTHDAY, SI.AVATAR, SI.SEX).from(SI).where(SI.SUID.in(suids))
				.fetchInto(StudentInfo.class);
	}

	public int getStudentTotalCnt() {
		return franchiseCtx.fetchCount(SI);
	}

	public boolean existCurrentStudent(String puid, String suid) {
		return franchiseCtx.fetchExists(SI, SI.PUID.eq(puid).and(SI.SUID.eq(suid)));
	}
	
	public Map<String, String> getStudentName(String puid) {
		return franchiseCtx.select(SI.SUID, SI.NAME).from(SI).where(SI.PUID.eq(puid)).fetchMap(SI.SUID, SI.NAME);
	}
}
