package com.jz.jar.franchise.wrapper;

import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;

public class StudentContractWrapper {

	private String contractId;
	private Integer totalOfficalLesson;
	private Integer noScheduleOfficalLesson;
	private Integer consumeOfficalLesson;
	private Integer totalExtraLesson;
	private Integer status;

	// 下面的需要业务层封装
	private Integer leftLeaveNum;
	private Integer contractTotalNum;
	private String coursePackId;
	private String coursePackName;
	private Long contractStartTime;
	private Long contractEndTime;
	private Double onePrice;
	private Integer consumeMoney;

	public static StudentContractWrapper of(StudentSchoolContract contract) {
		return new StudentContractWrapper().setContractId(contract.getContractId())
				.setTotalOfficalLesson(contract.getTotalOfficalLesson())
				.setNoScheduleOfficalLesson(contract.getNoScheduleOfficalLesson())
				.setConsumeOfficalLesson(contract.getConsumeOfficalLesson())
				.setTotalExtraLesson(contract.getTotalExtraLesson()).setStatus(contract.getStatus());
	}

	public String getContractId() {
		return contractId;
	}

	public StudentContractWrapper setContractId(String contractId) {
		this.contractId = contractId;
		return this;
	}

	public Integer getTotalOfficalLesson() {
		return totalOfficalLesson;
	}

	public StudentContractWrapper setTotalOfficalLesson(Integer totalOfficalLesson) {
		this.totalOfficalLesson = totalOfficalLesson;
		return this;
	}

	public Integer getNoScheduleOfficalLesson() {
		return noScheduleOfficalLesson;
	}

	public StudentContractWrapper setNoScheduleOfficalLesson(Integer noScheduleOfficalLesson) {
		this.noScheduleOfficalLesson = noScheduleOfficalLesson;
		return this;
	}

	public Integer getConsumeOfficalLesson() {
		return consumeOfficalLesson;
	}

	public StudentContractWrapper setConsumeOfficalLesson(Integer consumeOfficalLesson) {
		this.consumeOfficalLesson = consumeOfficalLesson;
		return this;
	}

	public Integer getTotalExtraLesson() {
		return totalExtraLesson;
	}

	public StudentContractWrapper setTotalExtraLesson(Integer totalExtraLesson) {
		this.totalExtraLesson = totalExtraLesson;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public StudentContractWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getCoursePackId() {
		return coursePackId;
	}

	public StudentContractWrapper setCoursePackId(String coursePackId) {
		this.coursePackId = coursePackId;
		return this;
	}

	public String getCoursePackName() {
		return coursePackName;
	}

	public StudentContractWrapper setCoursePackName(String coursePackName) {
		this.coursePackName = coursePackName;
		return this;
	}

	public Integer getLeftLeaveNum() {
		return leftLeaveNum;
	}

	public StudentContractWrapper setLeftLeaveNum(Integer leftLeaveNum) {
		this.leftLeaveNum = leftLeaveNum;
		return this;
	}

	public Integer getContractTotalNum() {
		return contractTotalNum;
	}

	public StudentContractWrapper setContractTotalNum(Integer contractTotalNum) {
		this.contractTotalNum = contractTotalNum;
		return this;
	}

	public Long getContractStartTime() {
		return contractStartTime;
	}

	public StudentContractWrapper setContractStartTime(Long contractStartTime) {
		this.contractStartTime = contractStartTime;
		return this;
	}

	public Long getContractEndTime() {
		return contractEndTime;
	}

	public StudentContractWrapper setContractEndTime(Long contractEndTime) {
		this.contractEndTime = contractEndTime;
		return this;
	}

	public Integer getConsumeMoney() {
		return consumeMoney;
	}

	public StudentContractWrapper setConsumeMoney(Integer consumeMoney) {
		this.consumeMoney = consumeMoney;
		return this;
	}

	public Double getOnePrice() {
		return onePrice;
	}

	public StudentContractWrapper setOnePrice(Double onePrice) {
		this.onePrice = onePrice;
		return this;
	}

}
