package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class HUserRoleRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.HuserRole H = Tables.HUSER_ROLE;

	public boolean isSuperAdmin(String uid) {
		return franchiseCtx.fetchExists(H, H.HUID.eq(uid).and(H.HROLE_ID.eq("super_admin")));
	}

	public List<String> getSuperAdmins() {
		return franchiseCtx.select(H.HUID).from(H).where(H.HROLE_ID.eq("super_admin")).fetchInto(String.class);
	}

	public List<String> getHrs() {
		return franchiseCtx.select(H.HUID).from(H).where(H.HROLE_ID.in("hr", "hr_master")).fetchInto(String.class);
	}

	public void deleteHrs(String uid) {
		franchiseCtx.deleteFrom(H).where(H.HUID.eq(uid)).execute();
	}

	public boolean isIntegrated(String uid) {
		return franchiseCtx.fetchExists(H,
				H.HUID.eq(uid).and(H.HROLE_ID.in("integrated_manager", "integrated_master")));
	}

	public boolean isOaContract(String uid) {
		return franchiseCtx.fetchExists(H,
				H.HUID.eq(uid).and(H.HROLE_ID.in("oa_contract", "super_admin")));
	}

	public boolean isHrMaster(String uid) {
		return franchiseCtx.fetchExists(H, H.HUID.eq(uid).and(H.HROLE_ID.in("hr_master", "super_admin", "ceo")));
	}

}