package com.jz.jar.franchise.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.TableField;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import com.jz.jooq.franchise.tables.records.LessonStudentRecord;

@Lazy
@Repository
public class LessonStudentRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;

	private static List<TableField<LessonStudentRecord, ?>> simpleFields;

	static {
		simpleFields = Arrays.asList(LS.SCHOOL_ID, LS.LESSON_ID, LS.CONTRACT_ID, LS.TYPE, LS.STATUS);
	}

	public List<LessonStudent> findSimpleInfo(String suid, String branchId, Collection<Integer> statuses) {
		Condition condition = LS.SUID.eq(suid).and(LS.BRAND_ID.eq(branchId));
		if (ArrayMapTools.isNotEmpty(statuses))
			condition = condition.and(LS.STATUS.in(statuses));
		return franchiseCtx.select(simpleFields).from(LS).where(condition).fetchInto(LessonStudent.class);
	}

	public LessonStudent getSimpleLessonStudent(String schoolId, String lessonId, String suid) {
		return franchiseCtx.select(simpleFields).from(LS)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid)))
				.fetchAnyInto(LessonStudent.class);
	}

	public void updateStatus(String schoolId, String lessonId, String suid, int status) {
		franchiseCtx.update(LS).set(LS.STATUS, status)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid))).execute();
	}

	public List<LessonStudent> findSimpleFinishedLessonInfo(String suid, String branchId) {
		return franchiseCtx.select(simpleFields).from(LS)
				.where(LS.SUID.eq(suid).and(LS.BRAND_ID.eq(branchId)).and(LS.TYPE.eq(1)).and(LS.STATUS.in(1, 2, 4)))
				.fetchInto(LessonStudent.class);
	}

}
