package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.LessonStudentRepository;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;

@Lazy
@Service
public class LessonStudentService {

	@Autowired
	private LessonStudentRepository lessonStudentRepository;

	public List<LessonStudent> findSimpleInfo(String suid, String branchId) {
		return this.findSimpleInfo(suid, branchId, null);
	}

	public List<LessonStudent> findSimpleInfo(String suid, String branchId, Collection<Integer> statuses) {
		return lessonStudentRepository.findSimpleInfo(suid, branchId, statuses);
	}

	public LessonStudent getSimpleLessonStudent(String schoolId, String lessonId, String suid) {
		return lessonStudentRepository.getSimpleLessonStudent(schoolId, lessonId, suid);
	}

	public void updateStatus(String schoolId, String lessonId, String suid, int status) {
		lessonStudentRepository.updateStatus(schoolId, lessonId, suid, status);
	}

	public List<LessonStudent> findSimpleFinishedLessonInfo(String suid, String branchId) {
		return lessonStudentRepository.findSimpleFinishedLessonInfo(suid, branchId);
	}

}
