package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.jooq.SortField;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import com.jz.jooq.franchise.tables.records.LessonRecord;

@Lazy
@Repository
public class LessonRepository extends FranchiseBaseRepository implements FranchiseConditionRepository<LessonRecord> {

	private static final com.jz.jooq.franchise.tables.Lesson LE = Tables.LESSON;

	public List<Lesson> findLesson(Map<String, Collection<String>> school2Lessons) {
		Condition condition = getOrWhereCondition(LE.SCHOOL_ID, LE.LESSON_ID, school2Lessons);
		return franchiseCtx.selectFrom(LE).where(condition).orderBy(LE.START_TIME.asc()).fetchInto(Lesson.class);
	}

	public Lesson getLesson(String schoolId, String lessonId) {
		return franchiseCtx.selectFrom(LE).where(LE.SCHOOL_ID.eq(schoolId).and(LE.LESSON_ID.eq(lessonId)))
				.fetchAnyInto(Lesson.class);
	}

	public List<Lesson> findLesson(Map<String, Collection<String>> school2Lessons, boolean asc, int start, int size) {
		SortField<Long> sortField = asc ? LE.START_TIME.asc() : LE.START_TIME.desc();
		Condition condition = getOrWhereCondition(LE.SCHOOL_ID, LE.LESSON_ID, school2Lessons);
		return franchiseCtx.selectFrom(LE).where(condition).orderBy(sortField).limit(start, size)
				.fetchInto(Lesson.class);
	}

	public int countLesson(Map<String, Collection<String>> school2Lessons) {
		return franchiseCtx.fetchCount(LE, getOrWhereCondition(LE.SCHOOL_ID, LE.LESSON_ID, school2Lessons));
	}
}
