/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.wrapper.CourseLessonWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.CourseHo;
import com.jz.jooq.franchise.tables.CourseHoLesson;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CourseRepository
extends FranchiseBaseRepository {
    private static final CourseHo CH = Tables.COURSE_HO;
    private static final CourseHoLesson CHL = Tables.COURSE_HO_LESSON;

    public List<com.jz.jooq.franchise.tables.pojos.CourseHo> getHoCourses(String brandId) {
        return this.franchiseCtx.selectFrom((Table)CH).where(new Condition[]{CourseRepository.CH.BRAND_ID.eq((Object)brandId)}).fetchInto(com.jz.jooq.franchise.tables.pojos.CourseHo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.CourseHo getHoCourse(String brandId, Integer courseId) {
        return (com.jz.jooq.franchise.tables.pojos.CourseHo)this.franchiseCtx.selectFrom((Table)CH).where(new Condition[]{CourseRepository.CH.BRAND_ID.eq((Object)brandId).and(CourseRepository.CH.COURSE_ID.eq((Object)courseId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.CourseHo.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CourseHo> mutiGetHoCourse(String brandId, Collection<Integer> courseIds) {
        return this.franchiseCtx.selectFrom((Table)CH).where(new Condition[]{CourseRepository.CH.BRAND_ID.eq((Object)brandId).and(CourseRepository.CH.COURSE_ID.in(courseIds))}).fetchInto(com.jz.jooq.franchise.tables.pojos.CourseHo.class);
    }

    public List<CourseLessonWrapper> getHoLessons(String brandId, Integer courseId) {
        return this.franchiseCtx.select((SelectField)CourseRepository.CHL.LESSON_TIME, (SelectField)CourseRepository.CHL.LESSON_TITLE).from((TableLike)CHL).where(new Condition[]{CourseRepository.CHL.BRAND_ID.eq((Object)brandId).and(CourseRepository.CHL.COURSE_ID.eq((Object)courseId))}).fetchInto(CourseLessonWrapper.class);
    }

    public List<CourseLessonWrapper> mutiGetHoLessons(String brandId, Collection<Integer> courseIds) {
        return this.franchiseCtx.select((SelectField)CourseRepository.CHL.COURSE_ID, (SelectField)CourseRepository.CHL.LESSON_TIME, (SelectField)CourseRepository.CHL.LESSON_TITLE).from((TableLike)CHL).where(new Condition[]{CourseRepository.CHL.BRAND_ID.eq((Object)brandId).and(CourseRepository.CHL.COURSE_ID.in(courseIds))}).fetchInto(CourseLessonWrapper.class);
    }
}

