package com.jz.jar.franchise.wrapper;

import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import com.jz.jar.franchise.common.FranchiseGobal;
import com.jz.jooq.franchise.tables.pojos.School;

public class SchoolWrapper {

	private String schoolId;
	private String schoolName;
	private String brandId;
	private Integer cityLevel;
	private Double lat;
	private Double lng;
	private Integer code;
	private Integer type;
	private Integer qualityType;
	private String phone;
	private String prov;
	private String city;
	private String company;
	private String centerName;
	private String centerAddress;
	private String stamp;
	private String merchantCode;
	private Integer status;
	private Long created;
	private Long prepareEndTime;
	private Long openTime;
	private Long joinTime;
	private Long contractEndTime;
	private Double qyRate;
	private Long lastCommunicateTime;
	private Long nextCommunicateTime;
	private Long foaLastCommunicateTime;
	private Long foaNextCommunicateTime;

	private UserPhoneWrapper investor; //
	private UserPhoneWrapper master; //
	private Integer openType; //
	private UserSimpleWrapper foc; //
	private UserSimpleWrapper foa; //
	private RegionWrapper region; //

	private Integer unReadNum; //

	private Integer goalTotalMoney;
	private Integer goalFirstMoney;
	private Integer goalSecondMoney;
	private Integer goalIntroMoney;

	private Integer totalMoney;
	private Integer firstMoney;
	private Integer secondMoney;
	private Integer introMoney;

	private Integer communicateUser;
	private Integer inviteUser;
	private Integer visitUser;
	private Integer firstContractUser;

	private Integer stuCommUser;
	private Integer stuCommNum;

	private Integer readingStuNum;

	private Integer auditStatus;

	public static SchoolWrapper ofSimple(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setCode(school.getCode());
	}

	public static SchoolWrapper ofContract(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setCompany(school.getCompany()).setCenterName(school.getCenterName())
				.setCenterAddress(school.getCenterAddress()).setStamp(school.getStamp());
	}

	public static SchoolWrapper ofAllInfo(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setBrandId(school.getBrandId()).setCityLevel(school.getCityLevel()).setLat(school.getLat())
				.setLng(school.getLng()).setCode(school.getCode()).setType(school.getType())
				.setQualityType(school.getQualityType()).setPhone(school.getPhone()).setProv(school.getProv())
				.setCity(school.getCity()).setCompany(school.getCompany()).setCenterName(school.getCenterName())
				.setCenterAddress(school.getCenterAddress()).setStamp(school.getStamp())
				.setMerchantCode(school.getMerchantCode()).setStatus(school.getStatus())
				.setCreated(school.getCreated()).setPrepareEndTime(school.getPrepareEndTime())
				.setOpenTime(school.getOpenTime()).setJoinTime(school.getJoinTime())
				.setContractEndTime(school.getContractEndTime()).setQyRate(school.getQyRate())
				.setStatus(school.getStatus()).setLastCommunicateTime(school.getLastCommunicateTime())
				.setNextCommunicateTime(school.getNextCommunicateTime())
				.setFoaLastCommunicateTime(school.getFoaLastCommunicateTime())
				.setFoaNextCommunicateTime(school.getFoaNextCommunicateTime());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public SchoolWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public SchoolWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	public String getCompany() {
		return company;
	}

	public SchoolWrapper setCompany(String company) {
		this.company = company;
		return this;
	}

	public String getCenterName() {
		return centerName;
	}

	public SchoolWrapper setCenterName(String centerName) {
		this.centerName = centerName;
		return this;
	}

	public String getCenterAddress() {
		return centerAddress;
	}

	public SchoolWrapper setCenterAddress(String centerAddress) {
		this.centerAddress = centerAddress;
		return this;
	}

	public String getStamp() {
		return stamp;
	}

	public SchoolWrapper setStamp(String stamp) {
		if (StringUtils.isNotEmpty(stamp)) {
			this.stamp = FranchiseGobal.picAddressPrefix + stamp;
		} else {
			this.stamp = stamp;
		}
		return this;
	}

	public String getBrandId() {
		return brandId;
	}

	public SchoolWrapper setBrandId(String brandId) {
		this.brandId = brandId;
		return this;
	}

	public Integer getCityLevel() {
		return cityLevel;
	}

	public SchoolWrapper setCityLevel(Integer cityLevel) {
		this.cityLevel = cityLevel;
		return this;
	}

	public Double getLat() {
		return lat;
	}

	public SchoolWrapper setLat(Double lat) {
		this.lat = lat;
		return this;
	}

	public Double getLng() {
		return lng;
	}

	public SchoolWrapper setLng(Double lng) {
		this.lng = lng != null ? lng.doubleValue() : null;
		return this;
	}

	public Integer getCode() {
		return code;
	}

	public SchoolWrapper setCode(Integer code) {
		this.code = code;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public SchoolWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

	public Integer getQualityType() {
		return qualityType;
	}

	public SchoolWrapper setQualityType(Integer qualityType) {
		this.qualityType = qualityType;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public SchoolWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public RegionWrapper getRegion() {
		return region;
	}

	public SchoolWrapper setRegion(RegionWrapper region) {
		this.region = region;
		return this;
	}

	public String getProv() {
		return prov;
	}

	public SchoolWrapper setProv(String prov) {
		this.prov = prov;
		return this;
	}

	public String getMerchantCode() {
		return merchantCode;
	}

	public SchoolWrapper setMerchantCode(String merchantCode) {
		this.merchantCode = merchantCode;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public SchoolWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Long getCreated() {
		return created;
	}

	public SchoolWrapper setCreated(Long created) {
		this.created = created;
		return this;
	}

	public Long getContractEndTime() {
		return contractEndTime;
	}

	public SchoolWrapper setContractEndTime(Long contractEndTime) {
		this.contractEndTime = contractEndTime;
		return this;
	}

	public Long getPrepareEndTime() {
		return prepareEndTime;
	}

	public SchoolWrapper setPrepareEndTime(Long prepareEndTime) {
		this.prepareEndTime = prepareEndTime;
		return this;
	}

	public Long getOpenTime() {
		return openTime;
	}

	public SchoolWrapper setOpenTime(Long openTime) {
		this.openTime = openTime;
		return this;
	}

	public Long getJoinTime() {
		return joinTime;
	}

	public SchoolWrapper setJoinTime(Long joinTime) {
		this.joinTime = joinTime;
		return this;
	}

	public Double getQyRate() {
		return qyRate;
	}

	public SchoolWrapper setQyRate(BigDecimal qyRate) {
		this.qyRate = qyRate != null ? qyRate.doubleValue() : null;
		return this;
	}

	public Integer getUnReadNum() {
		return unReadNum;
	}

	public SchoolWrapper setUnReadNum(Integer unReadNum) {
		this.unReadNum = unReadNum;
		return this;
	}

	public String getCity() {
		return city;
	}

	public SchoolWrapper setCity(String city) {
		this.city = city;
		return this;
	}

	public Long getLastCommunicateTime() {
		return lastCommunicateTime;
	}

	public SchoolWrapper setLastCommunicateTime(Long lastCommunicateTime) {
		this.lastCommunicateTime = lastCommunicateTime;
		return this;
	}

	public Long getNextCommunicateTime() {
		return nextCommunicateTime;
	}

	public SchoolWrapper setNextCommunicateTime(Long nextCommunicateTime) {
		this.nextCommunicateTime = nextCommunicateTime;
		return this;
	}

	public Integer getOpenType() {
		return openType;
	}

	public SchoolWrapper setOpenType(Integer openType) {
		this.openType = openType;
		return this;
	}

	public UserSimpleWrapper getFoc() {
		return foc;
	}

	public SchoolWrapper setFoc(UserSimpleWrapper foc) {
		this.foc = foc;
		return this;
	}

	public Long getFoaLastCommunicateTime() {
		return foaLastCommunicateTime;
	}

	public SchoolWrapper setFoaLastCommunicateTime(Long foaLastCommunicateTime) {
		this.foaLastCommunicateTime = foaLastCommunicateTime;
		return this;
	}

	public Long getFoaNextCommunicateTime() {
		return foaNextCommunicateTime;
	}

	public SchoolWrapper setFoaNextCommunicateTime(Long foaNextCommunicateTime) {
		this.foaNextCommunicateTime = foaNextCommunicateTime;
		return this;
	}

	public UserSimpleWrapper getFoa() {
		return foa;
	}

	public SchoolWrapper setFoa(UserSimpleWrapper foa) {
		this.foa = foa;
		return this;
	}

	public Integer getGoalTotalMoney() {
		return goalTotalMoney;
	}

	public SchoolWrapper setGoalTotalMoney(Integer goalTotalMoney) {
		this.goalTotalMoney = goalTotalMoney;
		return this;
	}

	public Integer getGoalFirstMoney() {
		return goalFirstMoney;
	}

	public SchoolWrapper setGoalFirstMoney(Integer goalFirstMoney) {
		this.goalFirstMoney = goalFirstMoney;
		return this;
	}

	public Integer getGoalSecondMoney() {
		return goalSecondMoney;
	}

	public SchoolWrapper setGoalSecondMoney(Integer goalSecondMoney) {
		this.goalSecondMoney = goalSecondMoney;
		return this;
	}

	public Integer getGoalIntroMoney() {
		return goalIntroMoney;
	}

	public SchoolWrapper setGoalIntroMoney(Integer goalIntroMoney) {
		this.goalIntroMoney = goalIntroMoney;
		return this;
	}

	public Integer getTotalMoney() {
		return totalMoney;
	}

	public SchoolWrapper setTotalMoney(Integer totalMoney) {
		this.totalMoney = totalMoney;
		return this;
	}

	public Integer getFirstMoney() {
		return firstMoney;
	}

	public SchoolWrapper setFirstMoney(Integer firstMoney) {
		this.firstMoney = firstMoney;
		return this;
	}

	public Integer getSecondMoney() {
		return secondMoney;
	}

	public SchoolWrapper setSecondMoney(Integer secondMoney) {
		this.secondMoney = secondMoney;
		return this;
	}

	public Integer getIntroMoney() {
		return introMoney;
	}

	public SchoolWrapper setIntroMoney(Integer introMoney) {
		this.introMoney = introMoney;
		return this;
	}

	public Integer getCommunicateUser() {
		return communicateUser;
	}

	public SchoolWrapper setCommunicateUser(Integer communicateUser) {
		this.communicateUser = communicateUser;
		return this;
	}

	public Integer getInviteUser() {
		return inviteUser;
	}

	public SchoolWrapper setInviteUser(Integer inviteUser) {
		this.inviteUser = inviteUser;
		return this;
	}

	public Integer getVisitUser() {
		return visitUser;
	}

	public SchoolWrapper setVisitUser(Integer visitUser) {
		this.visitUser = visitUser;
		return this;
	}

	public Integer getFirstContractUser() {
		return firstContractUser;
	}

	public SchoolWrapper setFirstContractUser(Integer firstContractUser) {
		this.firstContractUser = firstContractUser;
		return this;
	}

	public Integer getStuCommUser() {
		return stuCommUser;
	}

	public SchoolWrapper setStuCommUser(Integer stuCommUser) {
		this.stuCommUser = stuCommUser;
		return this;
	}

	public Integer getStuCommNum() {
		return stuCommNum;
	}

	public SchoolWrapper setStuCommNum(Integer stuCommNum) {
		this.stuCommNum = stuCommNum;
		return this;
	}

	public Integer getReadingStuNum() {
		return readingStuNum;
	}

	public SchoolWrapper setReadingStuNum(Integer readingStuNum) {
		this.readingStuNum = readingStuNum;
		return this;
	}

	public UserPhoneWrapper getInvestor() {
		return investor;
	}

	public SchoolWrapper setInvestor(UserPhoneWrapper investor) {
		this.investor = investor;
		return this;
	}

	public UserPhoneWrapper getMaster() {
		return master;
	}

	public SchoolWrapper setMaster(UserPhoneWrapper master) {
		this.master = master;
		return this;
	}

	public Integer getAuditStatus() {
		return auditStatus;
	}

	public SchoolWrapper setAuditStatus(Integer auditStatus) {
		this.auditStatus = auditStatus;
		return this;
	}

}
