package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.records.ParentInfoRecord;

@Lazy
@Repository
public class ParentInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ParentInfo PI = Tables.PARENT_INFO;

	public void savePatentInfo(String puid, String phone, int appLogin) {
		ParentInfoRecord parent = new ParentInfoRecord();
		parent.setPuid(puid);
		parent.setPhone(phone);
		parent.setAppLogin(appLogin);
		parent.setCreated(System.currentTimeMillis());
		franchiseCtx.insertInto(PI).set(parent).onDuplicateKeyIgnore().execute();
	}

	public ParentInfo getParentInfoForPhone(String phone) {
		List<ParentInfo> parents = franchiseCtx.selectFrom(PI).where(PI.PHONE.eq(phone)).fetchInto(ParentInfo.class);
		return ArrayMapTools.isNotEmpty(parents) ? parents.get(0) : null;
	}

	public void updateAppLogin(String phone) {
		franchiseCtx.update(PI).set(PI.APP_LOGIN, 1).where(PI.PHONE.eq(phone).and(PI.APP_LOGIN.eq(0))).execute();
	}
	
	public void updateAddressForUid(String puid, String address) {
		franchiseCtx.update(PI).set(PI.ADDRESS, address).where(PI.PUID.eq(puid)).execute();
	}
	
	public ParentInfo getParentInfoForId(String uid) {
		List<ParentInfo> parents = franchiseCtx.selectFrom(PI).where(PI.PUID.eq(uid)).fetchInto(ParentInfo.class);
		return ArrayMapTools.isNotEmpty(parents) ? parents.get(0) : null;
	}
}
