/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http.v2;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectTools;
import com.jz.common.utils.text.StringTools;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpServletRequest {
    private static final int DEFAULT_LIFE_TIME = 10000;
    private static final int DEFAULT_TIME_OUT = 5000;
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20191115 Gymchina/20.0";
    static final String UTF8 = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String sendHttpRequest(HttpRequestBase request, String charsetName, Map<String, String> header, Logger logger) throws IOException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionTimeToLive(10000L, TimeUnit.MILLISECONDS);
        String result = null;
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
            String _temp;
            CloseableHttpResponse response;
            String charset;
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
            request.setConfig(requestConfig);
            request.setHeader("accept", "*/*");
            request.setHeader("connection", "keep-alive");
            request.setHeader("user-agent", USER_AGENT);
            if (ArrayMapTools.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
            }
            charsetName = StringTools.isNotEmpty((CharSequence)(charset = ConnectTools.getCharsetFromResponse((HttpResponse)(response = closeableHttpClient.execute((HttpUriRequest)request))))) ? charset : charsetName;
            String string = _temp = null != response.getEntity() ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(charsetName)) : null;
            if (null != logger) {
                logger.info("CODE : {} || Result = {}", (Object)response.getStatusLine().getStatusCode(), (Object)_temp);
            }
            if (200 == response.getStatusLine().getStatusCode() && StringTools.isNotEmpty((CharSequence)_temp)) {
                result = _temp;
            }
        }
        return result;
    }
}

