/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http.v2;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.v2.HttpServletRequest;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletGet
extends HttpServletRequest {
    private static Logger logger = LoggerFactory.getLogger(HttpServletGet.class);

    public static String send(String url) {
        return HttpServletGet.send(url, null);
    }

    public static String send(String url, Map<String, String> params) {
        return HttpServletGet.send(url, params, "UTF-8", null, true);
    }

    public static String send(String url, Map<String, String> params, String charsetName) {
        return HttpServletGet.send(url, params, charsetName, null, true);
    }

    public static String send(String url, Map<String, String> params, boolean showLog) {
        return HttpServletGet.send(url, params, "UTF-8", null, showLog);
    }

    public static String send(String url, Map<String, String> params, Map<String, String> header) {
        return HttpServletGet.send(url, params, "UTF-8", header, true);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) {
        return HttpServletGet.send(url, params, "UTF-8", header, true);
    }

    public static String send(String url, Map<String, String> params, Map<String, String> header, boolean showLog) {
        return HttpServletGet.send(url, params, "UTF-8", header, showLog);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header, boolean showLog) {
        try {
            StringBuilder sb = new StringBuilder();
            if (ArrayMapTools.isNotEmpty(params)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    sb.append(entry.getKey()).append("=");
                    sb.append(URLEncoder.encode(entry.getValue(), charsetName)).append("&");
                }
                sb.delete(sb.length() - 1, sb.length());
            }
            if (sb.length() > 0) {
                url = url + (url.indexOf("?") > 0 ? "&" : "?") + sb.toString();
            }
            if (showLog) {
                logger.info("GET : {}", (Object)url);
            }
            return HttpServletGet.sendHttpRequest((HttpRequestBase)new HttpGet(url), charsetName, header, (Logger)(showLog ? logger : null));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

