/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectTools;
import com.jz.common.utils.text.StringTools;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSSLPost {
    private static Logger logger = LoggerFactory.getLogger(ConnectSSLPost.class);
    private static final int default_life_time = 10000;
    private static final int default_time_out = 5000;

    public static String send(String url) throws Exception {
        return ConnectSSLPost.send(url, true);
    }

    public static String send(String url, boolean showLog) throws Exception {
        return ConnectSSLPost.send(url, "UTF-8", showLog);
    }

    public static String send(String url, String charsetName) throws Exception {
        return ConnectSSLPost.send(url, charsetName, true);
    }

    public static String send(String url, String charsetName, boolean showLog) throws Exception {
        return ConnectSSLPost.send(url, null, charsetName, null, showLog);
    }

    public static String send(String url, Map<String, String> params, String charsetName) throws Exception {
        return ConnectSSLPost.send(url, params, charsetName, true);
    }

    public static String send(String url, Map<String, String> params, String charsetName, boolean showLog) throws Exception {
        return ConnectSSLPost.send(url, params, charsetName, null, showLog);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) throws Exception {
        return ConnectSSLPost.send(url, params, charsetName, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header, boolean showLog) throws Exception {
        if (showLog) {
            logger.info("URL = {},Parameters = {}", (Object)url, params);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionTimeToLive(10000L, TimeUnit.MILLISECONDS);
        String result = null;
        try (CloseableHttpClient closeableHttpClient = ConnectTools.createSSLInsecureClient();){
            String _temp;
            CloseableHttpResponse response;
            String charset;
            HttpPost post = new HttpPost(url);
            post.setConfig(RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build());
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            if (ArrayMapTools.isNotEmpty(params)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, charsetName));
            post.setHeader("accept", "*/*");
            post.setHeader("connection", "keep-alive");
            post.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:38.0) Gecko/20100101 Firefox/38.0");
            if (ArrayMapTools.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            charsetName = StringTools.isNotEmpty((CharSequence)(charset = ConnectTools.getCharsetFromResponse((HttpResponse)(response = closeableHttpClient.execute((HttpUriRequest)post))))) ? charset : charsetName;
            String string = _temp = null != response.getEntity() ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(charsetName)) : null;
            if (showLog) {
                logger.info("CODE : {} || Result = {}", (Object)response.getStatusLine().getStatusCode(), (Object)_temp);
            }
            if (200 == response.getStatusLine().getStatusCode() && StringTools.isNotEmpty((CharSequence)_temp)) {
                result = _temp;
            }
        }
        return result;
    }

    public static String sendBody(String url, String body) throws Exception {
        return ConnectSSLPost.sendBody(url, body, true);
    }

    public static String sendBody(String url, String body, String charsetName) throws Exception {
        return ConnectSSLPost.sendBody(url, body, charsetName, true);
    }

    public static String sendBody(String url, String body, boolean showLog) throws Exception {
        return ConnectSSLPost.sendBody(url, body, "UTF-8", showLog);
    }

    public static String sendBody(String url, String body, String charsetName, boolean showLog) throws Exception {
        return ConnectSSLPost.sendBody(url, body, charsetName, null, showLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendBody(String url, String body, String charsetName, Map<String, String> header, boolean showLog) throws Exception {
        if (showLog) {
            logger.info("URL = {}, body = {}", (Object)url, (Object)body);
        }
        String result = null;
        try (CloseableHttpClient closeableHttpClient = ConnectTools.createSSLInsecureClient();){
            String _temp;
            CloseableHttpResponse response;
            String charset;
            HttpPost post = new HttpPost(url);
            post.setConfig(RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build());
            StringEntity entity = new StringEntity(body, charsetName);
            post.setEntity((HttpEntity)entity);
            post.setHeader("accept", "*/*");
            post.setHeader("connection", "keep-alive");
            post.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:38.0) Gecko/20100101 Firefox/38.0");
            if (ArrayMapTools.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            charsetName = StringTools.isNotEmpty((CharSequence)(charset = ConnectTools.getCharsetFromResponse((HttpResponse)(response = closeableHttpClient.execute((HttpUriRequest)post))))) ? charset : charsetName;
            String string = _temp = null != response.getEntity() ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(charsetName)) : null;
            if (showLog) {
                logger.info("CODE : {} || Result = {}", (Object)response.getStatusLine().getStatusCode(), (Object)_temp);
            }
            if (200 == response.getStatusLine().getStatusCode() && StringTools.isNotEmpty((CharSequence)_temp)) {
                result = _temp;
            }
        }
        return result;
    }
}

