/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.datetime;

import com.jz.common.utils.text.StringTools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeTools {
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static long getTimestampModulus(int modulus) {
        return TimeTools.getCurrentTime() % (long)modulus;
    }

    public static void sleep(int seconds) {
        TimeTools.sleepMillis(seconds * 1000);
    }

    public static void sleepMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDateTime(long timestamp) {
        return dateTimeFormat.format(new Date(timestamp));
    }

    public static String getDateTime(long timestamp, String format) {
        return new SimpleDateFormat(format).format(new Date(timestamp));
    }

    public static String getDateTime(long timestamp, SimpleDateFormat format) {
        return format.format(new Date(timestamp));
    }

    public static long getUnixTime(String dateStr) {
        Date date = null;
        try {
            date = dateTimeFormat.parse(dateStr.trim());
        }
        catch (ParseException ex) {
            try {
                date = dateFormat.parse(dateStr.trim());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date != null ? date.getTime() : 0L;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static long getCurrentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getCurrentDate() {
        return TimeTools.getDateTime(System.currentTimeMillis());
    }

    public static String format(long seconds) {
        int h = (int)(seconds / 3600L);
        int m = (int)(seconds - (long)(h * 3600)) / 60;
        int s = (int)(seconds - (long)(h * 3600) - (long)(m * 60));
        return String.format("%s:%s:%s", h, m, s);
    }

    private static String transferDouble(int in) {
        return in > 9 ? in + "" : "0" + in;
    }

    public static String doubleFormat(long seconds) {
        int h = (int)(seconds / 3600L);
        int m = (int)(seconds - (long)(h * 3600)) / 60;
        int s = (int)(seconds - (long)(h * 3600) - (long)(m * 60));
        return String.format("%s:%s:%s", TimeTools.transferDouble(h), TimeTools.transferDouble(m), TimeTools.transferDouble(s));
    }

    public static long getWeekStartTime() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return c.getTimeInMillis();
    }

    public static int getCurrentDayInWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        return day_of_week == 0 ? 7 : day_of_week;
    }

    public static long getCurrentDayFirstTime() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getCurrentDayLastTime() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5) + 1, 0, 0, 0);
        c.set(14, 0);
        c.add(14, -1);
        return c.getTimeInMillis();
    }

    public static long getCurrentMonthAnyDayFirstTime(int anyDay) {
        if (anyDay < 1 || anyDay > 31) {
            throw new RuntimeException("anyDay values [1~31] error anyDay value : " + anyDay);
        }
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), anyDay, 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getCurrentMonthAnyDayLastTime(int anyDay) {
        if (anyDay < 1 || anyDay > 31) {
            throw new RuntimeException("anyDay values [1~31] error anyDay value : " + anyDay);
        }
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), anyDay + 1, 0, 0, 0);
        c.set(14, 0);
        c.add(14, -1);
        return c.getTimeInMillis();
    }

    public static long getCurrentMonthFirstTime() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), 1, 0, 0, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getCurrentMonthLastTime() {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2) + 1, 1, 0, 0, 0);
        c.set(14, 0);
        c.add(14, -1);
        return c.getTimeInMillis();
    }

    public static long getCurrentWeekAnyDayStartTime(int anyDay) {
        if (anyDay < 1 || anyDay > 7) {
            throw new RuntimeException("anyDay values [1~7] error anyDay value : " + anyDay);
        }
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.set(14, 0);
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + anyDay);
        return c.getTimeInMillis();
    }

    public static long getCurrentWeekAnyDayLastTime(int anyDay) {
        if (anyDay < 1 || anyDay > 7) {
            throw new RuntimeException("anyDay values [1~7] error anyDay value : " + anyDay);
        }
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5) + 1, 0, 0, 0);
        c.set(14, -1);
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + anyDay);
        return c.getTimeInMillis();
    }

    public static int getCurrentWeekOfYear() {
        Calendar calendar = Calendar.getInstance();
        int week = calendar.get(3);
        if (calendar.get(7) - 1 == 0) {
            --week;
        }
        if (week == 0) {
            calendar.add(5, -1);
            week = calendar.get(3);
        }
        return Integer.parseInt(calendar.get(1) + StringTools.twoDigits(week));
    }
}

