package com.jz.common.utils.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;

/**
 * @Title FileUtils.java
 * @Package com.waqu.common.utils.io
 * @author Administrator
 * @date 2015年5月22日 下午2:44:15
 * @version V1.0
 */
public class FileTools {

	public static File loadFile(String path) {
		File file = new File(path);
		return null != file && file.exists() ? file : null;
	}

	/**
	 * 获取当前文件夹下所有文件地址
	 * 
	 * @param file
	 *            父级文件夹
	 * @param subfolder
	 *            是否检索子文件夹
	 */
	public static List<String> getFilesPath(File file) {
		List<String> files = new ArrayList<>();
		getFilesPath(file, true, files);
		return files;
	}

	/**
	 * 获取当前文件夹下所有文件地址
	 * 
	 * @param file
	 *            父级文件夹
	 * @param subfolder
	 *            是否检索子文件夹
	 */
	public static List<String> getFilesPath(File file, boolean subfolder) {
		List<String> files = new ArrayList<>();
		getFilesPath(file, subfolder, files);
		return files;
	}

	private static void getFilesPath(File file, boolean subfolder, List<String> files) {
		if (null == file || !file.exists())
			return;

		if (file.isDirectory()) {
			for (File children : file.listFiles()) {
				if (subfolder) {
					getFilesPath(children, subfolder, files);
				} else {
					if (children.isFile())
						files.add(children.getPath());
				}
			}
		} else {
			files.add(file.getPath());
		}
	}

	/**
	 * 读取文本文件的内容
	 * 
	 * @param filename
	 * @param charSet
	 * @return
	 */
	public static String getContents(String filename, String charSet) {
		if (StringTools.isEmpty(filename) || StringTools.isEmpty(charSet))
			return null;
		StringBuffer output = new StringBuffer();
		try {
			InputStream is = new FileInputStream(filename);
			InputStreamReader file = new InputStreamReader(is, charSet);
			BufferedReader buff = new BufferedReader(file);
			String lineSeparator = FileTools.lineSeparator();
			String line = null;
			while ((line = buff.readLine()) != null) {
				output.append(line + lineSeparator);
			}
			buff.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return output.toString();
	}

	/**
	 * 读取文本文件的内容，并过滤以指定字符串开始的行
	 * 
	 * @Title getContents
	 * @param filename
	 * @param charSet
	 * @param startFilters
	 * @return String
	 */
	public static String getContents(String filename, String charSet, String... startFilters) {
		if (StringTools.isEmpty(filename) || StringTools.isEmpty(charSet)
				|| ArrayMapTools.isEmpty(startFilters))
			return null;

		StringBuffer output = new StringBuffer();
		try {
			InputStream is = new FileInputStream(filename);
			InputStreamReader file = new InputStreamReader(is, charSet);
			BufferedReader buff = new BufferedReader(file);
			String lineSeparator = FileTools.lineSeparator();
			String line = null;
			readLine: while ((line = buff.readLine()) != null) {
				for (String start : startFilters) {
					if (line.startsWith(start)) {
						continue readLine;
					}
				}
				output.append(line + lineSeparator);
			}
			buff.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return output.toString();
	}

	/** 取当前操作系统获的换行符 */
	public static String lineSeparator() {
		return System.getProperty("line.separator");
	}

	/**
	 * 写入文本内容到文件(指定字符集编码)
	 * 
	 * @param filename
	 * @param contents
	 * @param charSet
	 * @return
	 */
	public static Boolean putContents(String filename, String contents, String charSet) {
		Boolean result = false;
		PrintWriter printWriter = null;
		try {
			printWriter = new PrintWriter(filename, charSet);
			printWriter.write(contents);
			printWriter.flush();
			result = true;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (printWriter != null) {
				printWriter.close();
			}
			printWriter = null;
		}
		return result;
	}
}
