/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.bean;

import com.jz.aliyun.beans.AliyunConfig;
import com.jz.common.utils.security.EncryptionTools;
import com.jz.jar.business.enums.PictureCompress;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunBean {
    private static AliyunBean _this;
    @Value(value="${aliyun.access.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.key.secret}")
    private String accessSecret;
    @Value(value="${aliyun.oss.media.bucket}")
    private String ossMediaBucket;
    @Value(value="${aliyun.oss.images.domain}")
    private String ossImagesDomain;
    @Value(value="${aliyun.oss.media.domain}")
    private String ossMediaDomain;
    @Value(value="${aliyun.oss.media.cdn.auth.key}")
    private String ossMediaAuthKey;

    @PostConstruct
    public void registerClassInstance() {
        _this = this;
    }

    public static AliyunConfig getMediaAliyunConfig() {
        return AliyunConfig.of((String)AliyunBean._this.ossMediaDomain, (String)AliyunBean._this.accessKeyId, (String)AliyunBean._this.accessSecret, (String)AliyunBean._this.ossMediaBucket);
    }

    public static String getImagesUrl(String url, PictureCompress compress) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String resultUrl = AliyunBean.getImagesUrl(url);
        if (null == compress) {
            return resultUrl;
        }
        return resultUrl + "!" + compress.getCompressName();
    }

    public static String getImagesUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        return AliyunBean._this.ossImagesDomain + "/" + url;
    }

    public static String getMediaCdnAuthUrl(String url, int expireSeconds) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, expireSeconds);
        String time = Long.toString(calendar.getTimeInMillis() / 1000L, 16).toUpperCase();
        String md5 = EncryptionTools.MD5((String)(AliyunBean._this.ossMediaAuthKey + url + time));
        return AliyunBean._this.ossMediaDomain + "/" + md5 + "/" + time + url;
    }
}

