package com.jz.jar.business.wrapper;

import com.jz.jar.media.enums.CtxType;
import com.jz.jooq.media.tables.pojos.SysNotify;
import com.jz.jooq.media.tables.pojos.UserNotice;

public class NoticeWrapper {
	private NoticeWrapper() {
	}

	private Integer id;
	private String title;
	private String content;
	private String colorCtx;
	private Long createTime;
	private Boolean isRead;
	// sys notify
	private String url;

	private UserWrapper user;
	private WorksInfoWrapper works;
	private VideoWrapper video;

	public static NoticeWrapper of() {
		return new NoticeWrapper();
	}

	public static NoticeWrapper of(UserNotice notice, long readTime) {
		NoticeWrapper wrapper = new NoticeWrapper().setId(notice.getId()).setTitle(notice.getTitle())
				.setContent(notice.getContent()).setColorCtx(notice.getColorCtx()).setCreateTime(notice.getCreated())
				.setIsRead(readTime >= notice.getCreated());
		if (CtxType.url.name().equals(notice.getSourceType()))
			wrapper.setUrl(notice.getSourceId());
		return wrapper;
	}

	public static NoticeWrapper of(SysNotify sn, long readTime) {
		NoticeWrapper wrapper = new NoticeWrapper().setId(sn.getId()).setContent(sn.getContent())
				.setCreateTime(sn.getCreateTime()).setIsRead(readTime >= sn.getCreateTime());
		if (CtxType.url.name().equals(sn.getSourceType()))
			wrapper.setUrl(sn.getSourceId());
		return wrapper;
	}

	public Integer getId() {
		return id;
	}

	public NoticeWrapper setId(Integer id) {
		this.id = id;
		return this;
	}

	public String getContent() {
		return content;
	}

	public NoticeWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public NoticeWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Boolean getIsRead() {
		return isRead;
	}

	public NoticeWrapper setIsRead(Boolean isRead) {
		this.isRead = isRead;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public NoticeWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public WorksInfoWrapper getWorks() {
		return works;
	}

	public NoticeWrapper setWorks(WorksInfoWrapper works) {
		this.works = works;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public NoticeWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getColorCtx() {
		return colorCtx;
	}

	public NoticeWrapper setColorCtx(String colorCtx) {
		this.colorCtx = colorCtx;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public NoticeWrapper setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public String getUrl() {
		return url;
	}

	public NoticeWrapper setUrl(String url) {
		this.url = url;
		return this;
	}

}
