/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.request.VideoRequest;
import com.jz.jar.business.tool.VideoTool;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.service.UserCollectVideoService;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VideoProxy {
    @Autowired
    private MediaVideoService mediaVideoService;
    @Autowired
    private UserCollectVideoService userCollectVideoService;

    public VideoWrapper getVideoInfo(VideoRequest request, BrandEnum brand) {
        MediaVideo video = this.mediaVideoService.getVideo(request.getWid(), brand);
        if (null == video) {
            return null;
        }
        VideoWrapper videoWrapper = this.getVideoWrapper(request.getUid(), request.getPid(), video);
        if (brand == BrandEnum.playabc) {
            return videoWrapper;
        }
        videoWrapper.setCollectCnt(this.userCollectVideoService.countCollectForVideo(video.getWid()));
        boolean isCollect = this.userCollectVideoService.isCollect(request.getUid(), request.getPid(), video.getWid());
        return videoWrapper.setIsCollect(isCollect);
    }

    public List<ItemCard> getVideoCards(VideoRequest request) {
        List<VideoWrapper> videos = this.getVideoInfos(request);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoInfoNotPid(VideoRequest request) {
        List videos = this.mediaVideoService.findVideos(request.getWids());
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        Map wid2Cnt = this.userCollectVideoService.countCollectForVideo(request.getWids());
        ArrayList wrappers = Lists.newArrayList();
        for (MediaVideo it : videos) {
            VideoWrapper wrapper = this.getVideoWrapper(request.getUid(), null, it);
            wrapper.setCollectCnt(MapUtils.getInteger((Map)wid2Cnt, (Object)it.getWid(), (Integer)0));
            wrappers.add(wrapper);
        }
        return OrderTool.keepOrder(request.getWids(), (Collection)wrappers, VideoWrapper::getWid);
    }

    public List<VideoWrapper> getVideoInfos(VideoRequest request) {
        List<VideoWrapper> videos = this.getVideoInfoNotPid(request);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        videos.forEach(it -> it.setPid(request.getPid()));
        return videos;
    }

    public List<VideoWrapper> getVideoInfoForWid2Pid(String uid, Map<String, String> wid2Pid) {
        List<VideoWrapper> videos = this.getVideoInfoNotPid(VideoRequest.of(uid, wid2Pid.keySet()));
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        videos.forEach(it -> it.setPid((String)wid2Pid.get(it.getWid())));
        return videos;
    }

    private VideoWrapper getVideoWrapper(String uid, String pid, MediaVideo video) {
        VideoWrapper result = VideoWrapper.of(video).setPid(pid);
        VideoTool.getVideoUrl(video, result);
        VideoTool.getSnapshotUrl(uid, video, result);
        return result;
    }
}

