package com.jz.jar.business.response;

/**
 * @Title ReservationResponse
 * @Package com.jz.jar.business.response
 * @author tangjunfeng
 * @date 2018年11月20日 上午11:48:25
 * @version V1.0
 */
public class ReservationResponse {

	private Boolean success;
	private String msg;
	private Boolean isExist;
	
	public static ReservationResponse ok() {
		return new ReservationResponse().setSuccess(true);
	}
	
	public static ReservationResponse exist() {
		return new ReservationResponse().setSuccess(true).setIsExist(true);
	}
	
	public static ReservationResponse failed() {
		return new ReservationResponse().setSuccess(false);
	}

	public static ReservationResponse failed(String msg) {
		return new ReservationResponse().setSuccess(false).setMsg(msg);
	}

	public Boolean getSuccess() {
		return success;
	}

	public ReservationResponse setSuccess(Boolean success) {
		this.success = success;
		return this;
	}

	public String getMsg() {
		return msg;
	}

	public ReservationResponse setMsg(String msg) {
		this.msg = msg;
		return this;
	}

	public Boolean getIsExist() {
		return isExist;
	}

	public ReservationResponse setIsExist(Boolean isExist) {
		this.isExist = isExist;
		return this;
	}

}
