package com.jz.jar.business.request;

/**
 * @Title ReservationRequest
 * @Package com.jz.jar.business.request
 * @author tangjunfeng
 * @date 2018年11月20日 上午11:52:37
 * @version V1.0
 */
public class ReservationRequest {
	// 品牌
	private String brand;
	// 用户标识
	private String uid;
	private String phone;
	// 所选校区
	private String schoolId;
	// 学员信息
	private String name;
	private String sex;
	private String birthday;

	// 是否存在学员信息
	private Boolean isExistStudent;

	public static ReservationRequest of(String brand, String uid, String schoolId) {
		return new ReservationRequest().setBrand(brand).setUid(uid).setSchoolId(schoolId).setIsExistStudent(false);
	}

	public static ReservationRequest of(String brand, String phone, String schoolId, String name, String sex,
			String birthday) {
		return new ReservationRequest().setBrand(brand).setPhone(phone).setSchoolId(schoolId).setName(name).setSex(sex)
				.setBirthday(birthday).setIsExistStudent(true);
	}

	public String getBrand() {
		return brand;
	}

	public ReservationRequest setBrand(String brand) {
		this.brand = brand;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public ReservationRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public ReservationRequest setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getSchoolId() {
		return schoolId;
	}

	public ReservationRequest setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getName() {
		return name;
	}

	public ReservationRequest setName(String name) {
		this.name = name;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public ReservationRequest setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public ReservationRequest setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public Boolean getIsExistStudent() {
		return isExistStudent;
	}

	public ReservationRequest setIsExistStudent(Boolean isExistStudent) {
		this.isExistStudent = isExistStudent;
		return this;
	}

}
