package com.jz.jar.business.proxy;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.jz.IdTools;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;

/**
 * @Title ParentInfoBusinessProxy
 * @Package com.jz.jar.business.proxy
 * @author tangjunfeng
 * @date 2018年11月20日 上午10:25:14
 * @version V1.0
 */
@Lazy
@Service
public class ParentInfoBusinessProxy {

	@Autowired
	private ParentInfoService parentInfoService;

	/** result : (k : parentInfo, v : isRegister) */
	public Pair<ParentInfo, Boolean> getOrCreateParentInfo(String phone, boolean appLogin) {
		ParentInfo parentInfo = parentInfoService.getParentInfoForPhone(phone);
		if (null != parentInfo)
			return Pair.of(parentInfo, false);
		int appLoginVal = appLogin ? 1 : 0;
		parentInfoService.savePatentInfo(IdTools.encode(phone + System.nanoTime()), phone, appLoginVal);
		parentInfo = parentInfoService.getParentInfoForPhone(phone);
		if (null == parentInfo)
			throw new NullPointerException("register parent info failed");
		return Pair.of(parentInfo, true);
	}
}
