package com.jz.jar.business.wrapper;

import java.util.List;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.AiLessonSection;

/**
 * @author 连杰
 */
public class AiSectionWrapper {
	private AiSectionWrapper() {
	}

	// 视频信息
	private String sectionId;
	private String name;
	private String pic;
	private Integer status; // -1未解锁 0开始学习 1学习中 2已完成
	private String playMaterialId;

	private List<AiMaterialWrapper> materials;

	private String icon;
	private String iconLock;

	public static AiSectionWrapper of() {
		return new AiSectionWrapper();
	}

	public static AiSectionWrapper of(AiLessonSection s) {
		return new AiSectionWrapper().setSectionId(s.getSectionId()).setName(s.getName()).setPic(s.getPic())
				.setIcon(s.getIcon()).setIconLock(s.getIconLock());
	}

	public String getSectionId() {
		return sectionId;
	}

	public AiSectionWrapper setSectionId(String sectionId) {
		this.sectionId = sectionId;
		return this;
	}

	public String getName() {
		return name;
	}

	public AiSectionWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public AiSectionWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public List<AiMaterialWrapper> getMaterials() {
		return materials;
	}

	public AiSectionWrapper setMaterials(List<AiMaterialWrapper> materials) {
		this.materials = materials;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public AiSectionWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getPlayMaterialId() {
		return playMaterialId;
	}

	public AiSectionWrapper setPlayMaterialId(String playMaterialId) {
		this.playMaterialId = playMaterialId;
		return this;
	}

	public String getIcon() {
		return icon;
	}

	public AiSectionWrapper setIcon(String icon) {
		this.icon = AliyunBean.getImagesUrl(icon);
		return this;
	}

	public String getIconLock() {
		return iconLock;
	}

	public AiSectionWrapper setIconLock(String iconLock) {
		this.iconLock = AliyunBean.getImagesUrl(iconLock);
		return this;
	}

}
