/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.enums.TomatoEnum;
import com.jz.jar.business.wrapper.WTomatoAttribute;
import com.jz.jar.media.service.TomatoAttributesService;
import com.jz.jar.media.service.TomatoPlaylistAttributesService;
import com.jz.jooq.media.tables.pojos.TomatoAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class AttributesProxy {
    @Autowired
    private TomatoPlaylistAttributesService playlistAttributesService;
    @Autowired
    private TomatoAttributesService tomatoAttributesService;

    private Collection<WTomatoAttribute> packageAttribute(List<TomatoAttributes> attributes) {
        if (ArrayMapTools.isEmpty(attributes)) {
            return null;
        }
        HashMap has = Maps.newHashMap();
        attributes.forEach(_ta -> {
            TomatoEnum te = TomatoEnum.valueOf(_ta.getClassify());
            if (te == null || !te.isShow()) {
                return;
            }
            if (!has.containsKey((Object)te)) {
                has.put(te, WTomatoAttribute.of(te));
            }
            ((WTomatoAttribute)has.get((Object)te)).addChild(WTomatoAttribute.of(_ta));
        });
        return OrderTool.keepOrder(TomatoEnum.getNames(), has.values(), WTomatoAttribute::getTaid);
    }

    public Collection<WTomatoAttribute> getPlaylistAttributes(Collection<String> pids) {
        List attributes = this.playlistAttributesService.findAttributeIds(pids);
        if (ArrayMapTools.isEmpty((Collection)attributes)) {
            return null;
        }
        return this.packageAttribute(this.tomatoAttributesService.findAttributes((Collection)attributes));
    }

    public Collection<WTomatoAttribute> getAttributes() {
        return this.packageAttribute(this.tomatoAttributesService.findAllAttributes());
    }
}

