package com.jz.jar.business.wrapper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jz.jooq.media.tables.pojos.AiMaterial;

/**
 * @author 连杰
 */
public class AiMaterialWrapper {
	private AiMaterialWrapper() {
	}

	// 视频信息
	private String materialId;
	private String type;
	private Double rate;// 进度
	private JSONObject data;
	private String snapshotUrl;
	private Integer duration;
	private String hd;

	private String pic;
	private String audio;
	private Integer audioSec;
	private Integer score;
	private JSONArray details;

	public static AiMaterialWrapper of(AiMaterial m) {
		return new AiMaterialWrapper().setMaterialId(m.getId()).setType(m.getType());
	}

	public String getMaterialId() {
		return materialId;
	}

	public AiMaterialWrapper setMaterialId(String materialId) {
		this.materialId = materialId;
		return this;
	}

	public String getType() {
		return type;
	}

	public AiMaterialWrapper setType(String type) {
		this.type = type;
		return this;
	}

	public Double getRate() {
		return rate;
	}

	public AiMaterialWrapper setRate(Double rate) {
		this.rate = rate;
		return this;
	}

	public JSONObject getData() {
		return data;
	}

	public AiMaterialWrapper setData(JSONObject data) {
		this.data = data;
		return this;
	}

	public String getSnapshotUrl() {
		return snapshotUrl;
	}

	public AiMaterialWrapper setSnapshotUrl(String snapshotUrl) {
		this.snapshotUrl = snapshotUrl;
		return this;
	}

	public Integer getDuration() {
		return duration;
	}

	public AiMaterialWrapper setDuration(Integer duration) {
		this.duration = duration;
		return this;
	}

	public String getHd() {
		return hd;
	}

	public AiMaterialWrapper setHd(String hd) {
		this.hd = hd;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public AiMaterialWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getAudio() {
		return audio;
	}

	public AiMaterialWrapper setAudio(String audio) {
		this.audio = audio;
		return this;
	}

	public Integer getAudioSec() {
		return audioSec;
	}

	public AiMaterialWrapper setAudioSec(Integer audioSec) {
		this.audioSec = audioSec;
		return this;
	}

	public Integer getScore() {
		return score;
	}

	public AiMaterialWrapper setScore(Integer score) {
		this.score = score;
		return this;
	}

	public JSONArray getDetails() {
		return details;
	}

	public AiMaterialWrapper setDetails(JSONArray details) {
		this.details = details;
		return this;
	}

}
