/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.wrapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jar.business.enums.TimeStatus;
import com.jz.jar.business.wrapper.PlaylistWrapper;
import com.jz.jar.business.wrapper.TeacherWrapper;
import com.jz.jar.business.wrapper.WPBFeedback;
import com.jz.jar.franchise.wrapper.OnlineLessonWrapper;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import java.util.List;

public class LessonWrapper
extends WPBFeedback {
    private String schoolId;
    private String schoolName;
    private String lessonId;
    private String lessonName;
    private String pic;
    private Integer lessonTimes;
    private String lessonTitle;
    private Long startTime;
    private Long endTime;
    private String courseName;
    private TimeStatus classStatus;
    private String classroom;
    private List<TimeStatus> studentClassStatus;
    private TeacherWrapper teacher;
    private Boolean isLeave;
    private Boolean isTruant;
    private Integer status;
    private String contractId;
    private Integer currentLeaveNum;
    private Integer schoolLeaveNum;
    private Integer restLeaveNum;
    private PlaylistWrapper playlist;
    private String worksId;
    private Boolean isFormalLesson;
    private Integer lessonStudentType;
    private OnlineLessonWrapper onlineLesson;
    private String guideWid;

    private LessonWrapper() {
    }

    public static LessonWrapper of(Lesson lesson) {
        return new LessonWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId()).setLessonTimes(lesson.getLessonTime()).setLessonTitle(lesson.getContent()).setStartTime(lesson.getStartTime()).setEndTime(lesson.getEndTime()).setIsFormalLesson(null != lesson.getCourseId() && lesson.getCourseId() > 0);
    }

    public String getSchoolId() {
        return this.schoolId;
    }

    public LessonWrapper setSchoolId(String schoolId) {
        this.schoolId = schoolId;
        return this;
    }

    public String getSchoolName() {
        return this.schoolName;
    }

    public LessonWrapper setSchoolName(String schoolName) {
        this.schoolName = schoolName;
        return this;
    }

    public String getLessonId() {
        return this.lessonId;
    }

    public LessonWrapper setLessonId(String lessonId) {
        this.lessonId = lessonId;
        return this;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public LessonWrapper setLessonName(String lessonName) {
        this.lessonName = lessonName;
        return this;
    }

    public String getPic() {
        return this.pic;
    }

    public LessonWrapper setPic(String pic) {
        this.pic = pic;
        return this;
    }

    public Integer getLessonTimes() {
        return this.lessonTimes;
    }

    public LessonWrapper setLessonTimes(Integer lessonTimes) {
        this.lessonTimes = lessonTimes;
        return this;
    }

    public String getLessonTitle() {
        return this.lessonTitle;
    }

    public LessonWrapper setLessonTitle(String lessonTitle) {
        this.lessonTitle = lessonTitle;
        return this;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public LessonWrapper setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public LessonWrapper setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public LessonWrapper setCourseName(String courseName) {
        this.courseName = courseName;
        return this;
    }

    public TimeStatus getClassStatus() {
        return this.classStatus;
    }

    public LessonWrapper setClassStatus(TimeStatus classStatus) {
        this.classStatus = classStatus;
        return this;
    }

    public String getClassroom() {
        return this.classroom;
    }

    public LessonWrapper setClassroom(String classroom) {
        this.classroom = classroom;
        return this;
    }

    public List<TimeStatus> getStudentClassStatus() {
        return this.studentClassStatus;
    }

    public LessonWrapper setStudentClassStatus(List<TimeStatus> studentClassStatus) {
        this.studentClassStatus = studentClassStatus;
        return this;
    }

    public TeacherWrapper getTeacher() {
        return this.teacher;
    }

    public LessonWrapper setTeacher(TeacherWrapper teacher) {
        this.teacher = teacher;
        return this;
    }

    public Boolean getIsLeave() {
        return this.isLeave;
    }

    public LessonWrapper setIsLeave(Boolean isLeave) {
        this.isLeave = isLeave;
        return this;
    }

    public Boolean getIsTruant() {
        return this.isTruant;
    }

    public LessonWrapper setIsTruant(Boolean isTruant) {
        this.isTruant = isTruant;
        return this;
    }

    public String getContractId() {
        return this.contractId;
    }

    public LessonWrapper setContractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    @JsonIgnore
    public Integer getCurrentLeaveNum() {
        return this.currentLeaveNum;
    }

    public LessonWrapper setCurrentLeaveNum(Integer currentLeaveNum) {
        this.currentLeaveNum = currentLeaveNum;
        return this;
    }

    public Integer getSchoolLeaveNum() {
        return this.schoolLeaveNum;
    }

    public LessonWrapper setSchoolLeaveNum(Integer schoolLeaveNum) {
        this.schoolLeaveNum = schoolLeaveNum;
        return this;
    }

    public Integer getRestLeaveNum() {
        if (null != this.restLeaveNum) {
            return this.restLeaveNum;
        }
        if (null != this.schoolLeaveNum && null != this.currentLeaveNum) {
            this.restLeaveNum = this.schoolLeaveNum - this.currentLeaveNum;
            this.restLeaveNum = this.restLeaveNum < 0 ? 0 : this.restLeaveNum;
            return this.restLeaveNum;
        }
        if (null != this.schoolLeaveNum) {
            return this.schoolLeaveNum;
        }
        return this.restLeaveNum;
    }

    public LessonWrapper setRestLeaveNum(Integer restLeaveNum) {
        return this;
    }

    public PlaylistWrapper getPlaylist() {
        return this.playlist;
    }

    public LessonWrapper setPlaylist(PlaylistWrapper playlist) {
        this.playlist = playlist;
        return this;
    }

    public String getWorksId() {
        return this.worksId;
    }

    public LessonWrapper setWorksId(String worksId) {
        this.worksId = worksId;
        return this;
    }

    @JsonIgnore
    public Boolean getIsFormalLesson() {
        return this.isFormalLesson;
    }

    public LessonWrapper setIsFormalLesson(Boolean isFormalLesson) {
        this.isFormalLesson = isFormalLesson;
        return this;
    }

    public Integer getLessonStudentType() {
        return this.lessonStudentType;
    }

    public LessonWrapper setLessonStudentType(Integer lessonStudentType) {
        this.lessonStudentType = lessonStudentType;
        return this;
    }

    public OnlineLessonWrapper getOnlineLesson() {
        return this.onlineLesson;
    }

    public LessonWrapper setOnlineLesson(OnlineLessonWrapper onlineLesson) {
        this.onlineLesson = onlineLesson;
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public LessonWrapper setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public String getGuideWid() {
        return this.guideWid;
    }

    public LessonWrapper setGuideWid(String guideWid) {
        this.guideWid = guideWid;
        return this;
    }
}

