package com.jz.jar.business.wrapper;

import java.util.List;

import com.jz.jooq.franchise.tables.pojos.StudentInfo;

public class RecomStudentWrapper {
	private RecomStudentWrapper() {
	}

	private String suid;
	private String name;
	private String avatar;
	private String age;
	private Integer worksCnt;
	private String schoolName;
	private List<WorksInfoWrapper> works;
	private UserWrapper user;

	public static RecomStudentWrapper of(StudentInfo studentInfo) {
		return new RecomStudentWrapper().setSuid(studentInfo.getSuid()).setName(studentInfo.getName());
	}

	public String getSuid() {
		return suid;
	}

	public RecomStudentWrapper setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public RecomStudentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getAvatar() {
		return avatar;
	}

	public RecomStudentWrapper setAvatar(String avatar) {
		this.avatar = avatar;
		return this;
	}

	public Integer getWorksCnt() {
		return worksCnt;
	}

	public RecomStudentWrapper setWorksCnt(Integer worksCnt) {
		this.worksCnt = worksCnt;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public RecomStudentWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	public List<WorksInfoWrapper> getWorks() {
		return works;
	}

	public RecomStudentWrapper setWorks(List<WorksInfoWrapper> works) {
		this.works = works;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public RecomStudentWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public String getAge() {
		return age;
	}

	public RecomStudentWrapper setAge(String age) {
		this.age = age;
		return this;
	}

}
