/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Maps;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.wrapper.WWorkTopicTheme;
import com.jz.jar.media.service.WorksThemeRecommService;
import com.jz.jar.media.service.WorksThemeService;
import com.jz.jooq.media.tables.pojos.WorksTheme;
import com.jz.jooq.media.tables.pojos.WorksThemeRecomm;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorksThemeProxy {
    @Autowired
    private WorksThemeService worksThemeService;
    @Autowired
    private WorksThemeRecommService worksThemeRecommService;

    public Map<String, WWorkTopicTheme> mutiGetWorksThemeWithRecomPic(Collection<String> tids) {
        List themes = this.worksThemeService.mutiGetThemeInfos(tids);
        List recomms = this.worksThemeRecommService.mutiGetRecommPicsByThemeIds(tids);
        HashMap recomPicMap = Maps.newHashMap();
        for (WorksThemeRecomm recomm : recomms) {
            if (recomPicMap.containsKey(recomm.getThemeId())) continue;
            recomPicMap.put(recomm.getThemeId(), recomm.getPic());
        }
        HashMap rsMap = Maps.newHashMap();
        for (WorksTheme t : themes) {
            WWorkTopicTheme wrapper = WWorkTopicTheme.of(t);
            if (recomPicMap.containsKey(t.getId())) {
                wrapper.setPic(AliyunBean.getImagesUrl((String)recomPicMap.get(t.getId())));
            } else {
                wrapper.setPic(AliyunBean.getImagesUrl(t.getPic()));
            }
            rsMap.put(t.getId(), wrapper);
        }
        return rsMap;
    }
}

