package com.jz.jar.business.enums;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;

public enum TomatoEnum {
	/** 属性分类 */
	element("元素"), scene("场景"), tag("分类"), age("年龄");

	private String remarks;

	TomatoEnum(String remarks) {
		this.remarks = remarks;
	}

	public String getRemarks() {
		return remarks;
	}

	public boolean isShow() {
		return StringTools.contains(this, element, tag);
	}

	public static List<String> getNames() {
		return Lists.newArrayList(element.name(), scene.name(), tag.name(), age.name());
	}
}
