/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.wrapper.WebsiteBannerWrapper;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.service.MediaBannerService;
import com.jz.jooq.media.tables.pojos.MediaBanner;
import com.jz.jooq.website.tables.pojos.ActivityInfo;
import com.jz.jooq.website.tables.pojos.Art;
import com.jz.jooq.website.tables.pojos.Banner;
import com.jz.jooq.website.tables.pojos.NewsInfo;
import com.jz.website.enums.BannerEnum;
import com.jz.website.enums.BannerLocation;
import com.jz.website.enums.BannerType;
import com.jz.website.service.ActivityService;
import com.jz.website.service.ArtService;
import com.jz.website.service.NewsInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class BannerProxy {
    private static final Logger logger = LoggerFactory.getLogger(BannerProxy.class);
    @Autowired
    private MediaBannerService mediaBannerService;
    @Autowired
    private NewsInfoService newsInfoService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ArtService artService;

    public List<MediaBanner> getMediaBanner(BrandEnum brand, DbField bpg, String version) {
        List bannersAll = this.mediaBannerService.findOnlineBanners(brand, bpg);
        ArrayList banners = Lists.newArrayList();
        for (MediaBanner b : bannersAll) {
            b.setPic(AliyunBean.getImagesUrl(b.getPic()));
            if (StringUtils.isNotEmpty((CharSequence)b.getMinAppVersion()) && b.getMinAppVersion().compareTo(version) > 0 || b.getPopUp() == 1) continue;
            banners.add(b);
        }
        return banners;
    }

    public Pair<List<MediaBanner>, MediaBanner> getMediaBannerWithPop(BrandEnum brand, DbField bpg, String version) {
        List bannersAll = this.mediaBannerService.findOnlineBanners(brand, bpg);
        ArrayList banners = Lists.newArrayList();
        MediaBanner popUp = null;
        for (MediaBanner b : bannersAll) {
            b.setPic(AliyunBean.getImagesUrl(b.getPic()));
            if (StringUtils.isNotEmpty((CharSequence)b.getMinAppVersion()) && b.getMinAppVersion().compareTo(version) > 0) continue;
            if (b.getPopUp() == 1) {
                popUp = b;
                continue;
            }
            banners.add(b);
        }
        return Pair.of((Object)banners, popUp);
    }

    public BannerEnum getWebsiteBannerId(String brand, String school, BannerLocation location) {
        if (location == BannerLocation.study) {
            return BannerEnum.ho_study;
        }
        boolean isHeadOffice = brand.equals(school);
        if (location == BannerLocation.home) {
            return isHeadOffice ? BannerEnum.ho_home : BannerEnum.school_home;
        }
        if (location == BannerLocation.news) {
            return isHeadOffice ? BannerEnum.ho_news : BannerEnum.school_news;
        }
        return null;
    }

    public List<WebsiteBannerWrapper> packageWebsiteBanner(List<Banner> banners) {
        if (ArrayMapTools.isEmpty(banners)) {
            return null;
        }
        ArrayList orderKeys = Lists.newArrayList();
        HashMap type2Ids = Maps.newHashMap();
        banners.forEach(it -> {
            BannerType type = BannerType.valueOf((String)it.getType());
            if (null == type) {
                logger.error("unknow banner type : [?]", (Object)type);
                return;
            }
            if (!type2Ids.containsKey(type)) {
                type2Ids.put(type, Lists.newArrayList());
            }
            ((List)type2Ids.get(type)).add(it.getDataId());
            orderKeys.add(it.getType() + it.getDataId());
        });
        ArrayList resultMBanners = Lists.newArrayList();
        type2Ids.forEach((type, ids) -> {
            if (BannerType.news == type) {
                this.getMBanner((BannerType)type, this.newsInfoService.getBannerInfo(ids), NewsInfo::getId, NewsInfo::getTitle, NewsInfo::getBannerPic, resultMBanners);
                return;
            }
            if (BannerType.activity == type) {
                this.getMBanner((BannerType)type, this.activityService.getBannerInfo(ids), ActivityInfo::getActivityId, ActivityInfo::getTitle, ActivityInfo::getBannerPic, resultMBanners);
                return;
            }
            if (BannerType.art == type) {
                this.getMBanner((BannerType)type, this.artService.getBannerInfo(ids), Art::getId, Art::getTitle, Art::getBannerPic, resultMBanners);
                return;
            }
        });
        return OrderTool.keepOrder((Collection)orderKeys, (Collection)resultMBanners, o -> o.getType() + o.getId());
    }

    private <T> void getMBanner(BannerType type, List<T> arrays, Function<T, String> idMapper, Function<T, String> titleMapper, Function<T, String> picMapper, List<WebsiteBannerWrapper> banners) {
        arrays.forEach(t -> {
            String pic = AliyunBean.getImagesUrl((String)picMapper.apply(t));
            banners.add(WebsiteBannerWrapper.of(type.name(), (String)idMapper.apply(t), (String)titleMapper.apply(t), pic));
        });
    }
}

